/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetConsumer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetEndpoint
extends MockEndpoint
implements Service {
    private final transient Logger log;
    private volatile DataSet dataSet;
    private final AtomicInteger receivedCounter = new AtomicInteger();
    @UriParam
    private int minRate;
    @UriParam
    private long produceDelay = 3L;
    @UriParam
    private long consumeDelay;
    @UriParam
    private long preloadSize;
    @UriParam
    private long initialDelay = 1000L;

    @Deprecated
    public DataSetEndpoint() {
        this.log = LoggerFactory.getLogger(DataSetEndpoint.class);
        this.copyOnExchange = false;
    }

    public DataSetEndpoint(String endpointUri, Component component, DataSet dataSet) {
        super(endpointUri, component);
        this.dataSet = dataSet;
        this.log = LoggerFactory.getLogger((String)endpointUri);
        this.copyOnExchange = false;
    }

    public static void assertEquals(String description, Object expected, Object actual, Exchange exchange) {
        if (!ObjectHelper.equal(expected, actual)) {
            throw new AssertionError((Object)(description + " does not match. Expected: " + expected + " but was: " + actual + " on " + exchange + " with headers: " + exchange.getIn().getHeaders()));
        }
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        DataSetConsumer answer = new DataSetConsumer(this, processor);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public void reset() {
        super.reset();
        this.receivedCounter.set(0);
    }

    @Override
    public int getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public Exchange createExchange(long messageIndex) throws Exception {
        Exchange exchange = this.createExchange();
        this.getDataSet().populateMessage(exchange, messageIndex);
        Message in = exchange.getIn();
        in.setHeader("CamelDataSetIndex", messageIndex);
        return exchange;
    }

    public int getMinRate() {
        return this.minRate;
    }

    public void setMinRate(int minRate) {
        this.minRate = minRate;
    }

    @Override
    protected void waitForCompleteLatch(long timeout) throws InterruptedException {
        super.waitForCompleteLatch(timeout);
        if (this.minRate > 0) {
            int count = this.getReceivedCounter();
            do {
                super.waitForCompleteLatch(1000L);
            } while ((count = this.getReceivedCounter() - count) >= this.minRate);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public long getPreloadSize() {
        return this.preloadSize;
    }

    public void setPreloadSize(long preloadSize) {
        this.preloadSize = preloadSize;
    }

    public long getConsumeDelay() {
        return this.consumeDelay;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    public long getProduceDelay() {
        return this.produceDelay;
    }

    public void setProduceDelay(long produceDelay) {
        this.produceDelay = produceDelay;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Override
    protected void performAssertions(Exchange actual, Exchange copy) throws Exception {
        int receivedCount = this.receivedCounter.incrementAndGet();
        long index = receivedCount - 1;
        Exchange expected = this.createExchange(index);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received message: {} (DataSet index={}) = {}", new Object[]{index, copy.getIn().getHeader("CamelDataSetIndex", Integer.class), copy});
        }
        this.assertMessageExpected(index, expected, copy);
        if (this.consumeDelay > 0L) {
            Thread.sleep(this.consumeDelay);
        }
    }

    protected void assertMessageExpected(long index, Exchange expected, Exchange actual) throws Exception {
        long actualCounter = ExchangeHelper.getMandatoryHeader(actual, "CamelDataSetIndex", Long.class);
        DataSetEndpoint.assertEquals("Header: CamelDataSetIndex", index, actualCounter, actual);
        this.getDataSet().assertMessageExpected(this, expected, actual, index);
    }

    protected ThroughputLogger createReporter() {
        String uri = URISupport.sanitizeUri(this.getEndpointUri());
        CamelLogger logger = new CamelLogger(uri);
        ThroughputLogger answer = new ThroughputLogger(logger, (int)this.getDataSet().getReportCount());
        answer.setAction("Received");
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        long size = this.getDataSet().getSize();
        this.expectedMessageCount((int)size);
        if (this.reporter == null) {
            this.reporter = this.createReporter();
        }
        this.log.info(this + " expecting " + size + " messages");
    }
}

