/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements AugmentedPropertyNameAwarePropertiesParser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        return this.parseUri(text, properties, prefixToken, suffixToken, null, null, false);
    }

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) throws IllegalArgumentException {
        String answer = text;
        boolean done = false;
        ArrayList<String> visited = new ArrayList<String>();
        while (!done) {
            ArrayList<String> replaced = new ArrayList<String>();
            answer = this.doParseUri(answer, properties, replaced, prefixToken, suffixToken, propertyPrefix, propertySuffix, fallbackToUnaugmentedProperty);
            for (String replace : replaced) {
                if (!visited.contains(replace)) continue;
                throw new IllegalArgumentException("Circular reference detected with key [" + replace + "] from text: " + text);
            }
            visited.addAll(replaced);
            done = this.findTokenPosition(answer, 0, prefixToken) == -1;
        }
        return answer;
    }

    @Override
    public String parseProperty(String key, String value, Properties properties) {
        return value;
    }

    private String doParseUri(String uri, Properties properties, List<String> replaced, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) {
        StringBuilder sb = new StringBuilder();
        int pivot = 0;
        int size = uri.length();
        while (pivot < size) {
            String part;
            String key;
            int endIdx;
            int idx = this.findTokenPosition(uri, pivot, prefixToken);
            if (idx < 0) {
                sb.append(this.createConstantPart(uri, pivot, size));
                break;
            }
            if (pivot < idx) {
                sb.append(this.createConstantPart(uri, pivot, idx));
            }
            if ((endIdx = this.findTokenPosition(uri, pivot = idx + prefixToken.length(), suffixToken)) < 0) {
                throw new IllegalArgumentException("Expecting " + suffixToken + " but found end of string from text: " + uri);
            }
            String augmentedKey = key = uri.substring(pivot, endIdx);
            if (propertyPrefix != null) {
                this.log.debug("Augmenting property key [{}] with prefix: {}", (Object)key, (Object)propertyPrefix);
                augmentedKey = propertyPrefix + augmentedKey;
            }
            if (propertySuffix != null) {
                this.log.debug("Augmenting property key [{}] with suffix: {}", (Object)key, (Object)propertySuffix);
                augmentedKey = augmentedKey + propertySuffix;
            }
            if ((part = this.createPlaceholderPart(augmentedKey, properties, replaced, prefixToken, suffixToken)) == null && fallbackToUnaugmentedProperty && (propertyPrefix != null || propertySuffix != null)) {
                this.log.debug("Property wth key [{}] not found, attempting with unaugmented key: {}", (Object)augmentedKey, (Object)key);
                part = this.createPlaceholderPart(key, properties, replaced, prefixToken, suffixToken);
            }
            if (part == null) {
                StringBuilder esb = new StringBuilder();
                esb.append("Property with key [").append(augmentedKey).append("] ");
                if (fallbackToUnaugmentedProperty && (propertyPrefix != null || propertySuffix != null)) {
                    esb.append("(and original key [").append(key).append("]) ");
                }
                esb.append("not found in properties from text: ").append(uri);
                throw new IllegalArgumentException(esb.toString());
            }
            sb.append(part);
            pivot = endIdx + suffixToken.length();
        }
        return sb.toString();
    }

    private int findTokenPosition(String uri, int pivot, String token) {
        int idx = uri.indexOf(token, pivot);
        while (idx > 0) {
            String part = null;
            int len = idx + token.length() + 1;
            if (uri.length() >= len) {
                part = uri.substring(idx - 1, len);
            }
            if (StringHelper.isQuoted(part)) {
                pivot = idx + token.length() + 1;
                idx = uri.indexOf(token, pivot);
                continue;
            }
            return idx;
        }
        return idx;
    }

    private boolean isNestProperty(String uri, String prefixToken, String suffixToken) {
        return ObjectHelper.isNotEmpty(uri) && (uri = uri.trim()).startsWith(prefixToken) && uri.endsWith(suffixToken);
    }

    private String takeOffNestTokes(String uri, String prefixToken, String suffixToken) {
        int start = prefixToken.length();
        int end = uri.length() - suffixToken.length();
        return uri.substring(start, end);
    }

    private String createConstantPart(String uri, int start, int end) {
        return uri.substring(start, end);
    }

    private String createPlaceholderPart(String key, Properties properties, List<String> replaced, String prefixToken, String suffixToken) {
        replaced.add(key);
        String propertyValue = System.getProperty(key);
        if (propertyValue != null) {
            this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)propertyValue);
        } else if (properties != null) {
            propertyValue = properties.getProperty(key);
        }
        ArrayList<String> visited = new ArrayList<String>();
        while (this.isNestProperty(propertyValue, prefixToken, suffixToken)) {
            visited.add(key);
            String value = this.takeOffNestTokes(propertyValue, prefixToken, suffixToken);
            key = this.parseUri(value, properties, prefixToken, suffixToken);
            if (visited.contains(key)) {
                throw new IllegalArgumentException("Circular reference detected with key [" + key + "] from text: " + propertyValue);
            }
            propertyValue = System.getProperty(key);
            if (propertyValue != null) {
                this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)propertyValue);
                continue;
            }
            if (properties == null) continue;
            propertyValue = properties.getProperty(key);
        }
        return this.parseProperty(key, propertyValue, properties);
    }
}

