/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.HostUtils;
import io.fabric8.utils.Ports;
import io.fabric8.zookeeper.bootstrap.DataStoreBootstrapTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.configuration", immediate=true)
@Service(value={BootstrapConfiguration.class})
public class BootstrapConfiguration
extends AbstractComponent {
    static final Logger LOGGER = LoggerFactory.getLogger(BootstrapConfiguration.class);
    public static final String COMPONENT_NAME = "io.fabric8.zookeeper.configuration";
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=DataStoreRegistrationHandler.class)
    private final ValidatingReference<DataStoreRegistrationHandler> registrationHandler = new ValidatingReference();
    private CreateEnsembleOptions options;

    @Activate
    void activate() throws Exception {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String karafHome = sysprops.getProperty("karaf.home");
        org.apache.felix.utils.properties.Properties userProps = null;
        try {
            userProps = new org.apache.felix.utils.properties.Properties(new File(karafHome + "/etc/users.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load users from etc/users.properties. No users will be imported.", (Throwable)e);
        }
        this.options = CreateEnsembleOptions.builder().fromRuntimeProperties(sysprops).users(userProps).build();
        if (this.options.isEnsembleStart()) {
            String connectionUrl = this.getConnectionUrl(this.options);
            ((DataStoreRegistrationHandler)this.registrationHandler.get()).setRegistrationCallback((DataStoreTemplate)new DataStoreBootstrapTemplate(sysprops, connectionUrl, this.options));
            this.createOrUpdateDataStoreConfig(this.options);
            this.createZooKeeeperServerConfig(this.options);
            this.createZooKeeeperClientConfig(connectionUrl, this.options);
            this.resetEnsembleAutoStart(sysprops);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    private void resetEnsembleAutoStart(RuntimeProperties sysprops) throws IOException {
        String karafHome = sysprops.getProperty("karaf.home");
        sysprops.setProperty("ensemble.auto.start", Boolean.FALSE.toString());
        File file = new File(karafHome + "/etc/system.properties");
        org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file);
        props.put("ensemble.auto.start", Boolean.FALSE.toString());
        props.save();
    }

    public CreateEnsembleOptions getBootstrapOptions() {
        this.assertValid();
        return this.options;
    }

    public String getConnectionUrl(CreateEnsembleOptions options) throws UnknownHostException {
        int zooKeeperServerConnectionPort = options.getZooKeeperServerConnectionPort();
        String connectionUrl = this.getConnectionAddress() + ":" + zooKeeperServerConnectionPort;
        return connectionUrl;
    }

    public void createOrUpdateDataStoreConfig(CreateEnsembleOptions options) throws IOException {
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.datastore", null);
        Hashtable<String, String> properties = config.getProperties();
        if (properties == null || ((Dictionary)properties).isEmpty()) {
            boolean updateConfig = false;
            properties = new Hashtable<String, String>();
            Map dataStoreProperties = options.getDataStoreProperties();
            for (Map.Entry entry : dataStoreProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String oldval = ((Dictionary)properties).put(key, value);
                updateConfig = updateConfig || !value.equals(oldval);
            }
            if (updateConfig) {
                config.update(properties);
            }
        }
    }

    public void createZooKeeeperServerConfig(CreateEnsembleOptions options) throws IOException {
        int serverPort = Ports.mapPortToRange(options.getZooKeeperServerPort(), options.getMinimumPort(), options.getMaximumPort());
        String serverHost = options.getBindAddress();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (options.isAutoImportEnabled()) {
            this.loadPropertiesFrom(properties, options.getImportPath() + "/fabric/configs/versions/1.0/profiles/default/io.fabric8.zookeeper.server.properties");
        }
        ((Dictionary)properties).put("tickTime", String.valueOf(options.getZooKeeperServerTickTime()));
        ((Dictionary)properties).put("initLimit", String.valueOf(options.getZooKeeperServerInitLimit()));
        ((Dictionary)properties).put("syncLimit", String.valueOf(options.getZooKeeperServerSyncLimit()));
        ((Dictionary)properties).put("dataDir", options.getZooKeeperServerDataDir() + "/" + "0000");
        ((Dictionary)properties).put("clientPort", Integer.toString(serverPort));
        ((Dictionary)properties).put("clientPortAddress", serverHost);
        ((Dictionary)properties).put("fabric.zookeeper.pid", "io.fabric8.zookeeper.server-0000");
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).createFactoryConfiguration("io.fabric8.zookeeper.server", null);
        config.update(properties);
    }

    public void createZooKeeeperClientConfig(String connectionUrl, CreateEnsembleOptions options) throws IOException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (options.isAutoImportEnabled()) {
            this.loadPropertiesFrom(properties, options.getImportPath() + "/fabric/configs/versions/1.0/profiles/default/io.fabric8.zookeeper.properties");
        }
        ((Dictionary)properties).put("zookeeper.url", connectionUrl);
        ((Dictionary)properties).put("zookeeper.timeout", System.getProperties().containsKey("zookeeper.timeout") ? System.getProperties().getProperty("zookeeper.timeout") : "30000");
        ((Dictionary)properties).put("fabric.zookeeper.pid", "io.fabric8.zookeeper");
        ((Dictionary)properties).put("zookeeper.password", options.getZookeeperPassword());
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper", null);
        config.update(properties);
    }

    private String getConnectionAddress() throws UnknownHostException {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String resolver = sysprops.getProperty("local.resolver", sysprops.getProperty("global.resolver", "localhostname"));
        if (resolver.equals("localhostname")) {
            return HostUtils.getLocalHostName();
        }
        if (resolver.equals("localip")) {
            return HostUtils.getLocalIp();
        }
        if (resolver.equals("manualip") && sysprops.getProperty("manualip", null) != null) {
            return sysprops.getProperty("manualip", null);
        }
        return HostUtils.getLocalHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Dictionary<String, Object> dictionary, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                dictionary.put(key, properties.get(key));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.bind((Object)service);
    }

    void unbindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.unbind((Object)service);
    }
}

