/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.FabricException;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.Ports;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.curator.CuratorACLManager;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DataStoreBootstrapTemplate
implements DataStoreTemplate {
    private final String connectionUrl;
    private final CreateEnsembleOptions options;
    private final String version;
    private final RuntimeProperties runtimeProperties;
    private final CuratorACLManager aclManager = new CuratorACLManager();

    public DataStoreBootstrapTemplate(RuntimeProperties runtimeProperties, String connectionUrl, CreateEnsembleOptions options) {
        this.runtimeProperties = runtimeProperties;
        this.connectionUrl = connectionUrl;
        this.options = options;
        this.version = options.getVersion();
    }

    public void doWith(DataStore dataStore) {
        int minimumPort = this.options.getMinimumPort();
        int maximumPort = this.options.getMaximumPort();
        String zooKeeperServerHost = this.options.getBindAddress();
        int zooKeeperServerPort = this.options.getZooKeeperServerPort();
        int zooKeeperServerConnectionPort = this.options.getZooKeeperServerConnectionPort();
        int mappedPort = Ports.mapPortToRange(zooKeeperServerPort, minimumPort, maximumPort);
        CuratorFramework curator = null;
        try {
            curator = this.createCuratorFramework(this.connectionUrl, this.options);
            curator.start();
            curator.getZookeeperClient().blockUntilConnectedOrTimedOut();
            File importPath = new File(this.options.getImportPath());
            if (!importPath.isAbsolute()) {
                String karafHome = this.runtimeProperties.getProperty("karaf.home");
                importPath = new File(karafHome, this.options.getImportPath());
            }
            if (this.options.isAutoImportEnabled()) {
                dataStore.importFromFileSystem(importPath.getAbsolutePath());
            }
            ZooKeeperUtils.setData(curator, ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), this.version);
            String defaultProfile = dataStore.getProfile(this.version, "default", true);
            String karafName = this.runtimeProperties.getProperty("karaf.name");
            ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), "${zk:" + karafName + "/ip}:" + zooKeeperServerConnectionPort);
            ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), this.options.getZookeeperPassword());
            Properties zkProps = new Properties();
            zkProps.setProperty("zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
            zkProps.setProperty("zookeeper.password", "${zk:" + ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]) + "}");
            dataStore.setFileConfiguration(this.version, defaultProfile, "io.fabric8.zookeeper.properties", DataStoreUtils.toBytes(zkProps));
            String ensembleProfile = dataStore.getProfile(this.version, "fabric-ensemble-0000", true);
            dataStore.setProfileAttribute(this.version, ensembleProfile, "abstract", "true");
            dataStore.setProfileAttribute(this.version, ensembleProfile, "hidden", "true");
            Properties ensembleProps = new Properties();
            ensembleProps.put("tickTime", String.valueOf(this.options.getZooKeeperServerTickTime()));
            ensembleProps.put("initLimit", String.valueOf(this.options.getZooKeeperServerInitLimit()));
            ensembleProps.put("syncLimit", String.valueOf(this.options.getZooKeeperServerSyncLimit()));
            ensembleProps.put("dataDir", this.options.getZooKeeperServerDataDir() + "/" + "0000");
            this.loadPropertiesFrom(ensembleProps, importPath + "/fabric/configs/versions/1.0/profiles/default/io.fabric8.zookeeper.server.properties");
            dataStore.setFileConfiguration(this.version, ensembleProfile, "io.fabric8.zookeeper.server-0000.properties", DataStoreUtils.toBytes(ensembleProps));
            String ensembleServerProfile = dataStore.getProfile(this.version, "fabric-ensemble-0000-1", true);
            dataStore.setProfileAttribute(this.version, ensembleServerProfile, "hidden", "true");
            dataStore.setProfileAttribute(this.version, ensembleServerProfile, "parents", ensembleProfile);
            Properties serverProps = new Properties();
            serverProps.put("clientPort", String.valueOf(mappedPort));
            serverProps.put("clientPortAddress", zooKeeperServerHost);
            dataStore.setFileConfiguration(this.version, ensembleServerProfile, "io.fabric8.zookeeper.server-0000.properties", DataStoreUtils.toBytes(serverProps));
            ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]), "0000");
            ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLE.getPath("0000"), karafName);
            String fabricProfile = dataStore.getProfile(this.version, "fabric", true);
            Properties agentProps = DataStoreUtils.toProperties(dataStore.getFileConfiguration(this.version, fabricProfile, "io.fabric8.agent.properties"));
            agentProps.put("feature.fabric-commands", "fabric-commands");
            dataStore.setFileConfiguration(this.version, "fabric", "io.fabric8.agent.properties", DataStoreUtils.toBytes(agentProps));
            ZooKeeperUtils.createDefault(curator, ZkPath.CONFIG_CONTAINER.getPath(karafName), this.version);
            StringBuilder profilesBuilder = new StringBuilder();
            Set profiles = this.options.getProfiles();
            profilesBuilder.append("fabric").append(" ").append("fabric-ensemble-0000-1");
            for (String p : profiles) {
                profilesBuilder.append(" ").append(p);
            }
            if (!this.options.isAgentEnabled()) {
                profilesBuilder.append(" ").append("unmanaged");
            }
            ZooKeeperUtils.createDefault(curator, ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(this.version, karafName), profilesBuilder.toString());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("encryption.enabled", "${zk:/fabric/authentication/encryption.enabled}");
            dataStore.setConfiguration(this.version, defaultProfile, "io.fabric8.jaas", configs);
            EncryptionSupport encryption = this.addUsersToZookeeper(curator, this.options.getUsers());
            ZooKeeperUtils.createDefault(curator, "/fabric/authentication/encryption.enabled", Boolean.valueOf(encryption != null).toString());
            ZooKeeperUtils.createDefault(curator, "/fabric/authentication/domain", "karaf");
            ZooKeeperUtils.createDefault(curator, ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]), "PBEWithMD5AndDES");
            ZooKeeperUtils.createDefault(curator, ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]), this.options.getZookeeperPassword());
            this.aclManager.fixAcl(curator, "/fabric", true);
        }
        catch (Exception ex) {
            throw new FabricException("Unable to create bootstrap configuration", (Throwable)ex);
        }
        finally {
            curator.close();
        }
    }

    private CuratorFramework createCuratorFramework(String connectionUrl, CreateEnsembleOptions options) throws IOException {
        return CuratorFrameworkFactory.builder().connectString(connectionUrl).connectionTimeoutMs(15000).sessionTimeoutMs(60000).aclProvider(this.aclManager).authorization("digest", ("fabric:" + options.getZookeeperPassword()).getBytes()).retryPolicy(new RetryNTimes(3, 500)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Properties targetProperties, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                targetProperties.put(key, properties.get(key));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private EncryptionSupport addUsersToZookeeper(CuratorFramework curator, Map<String, String> users) throws Exception {
        Pattern p = Pattern.compile("(.+),(.+)");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("encryption.prefix", "{CRYPT}");
        options.put("encryption.suffix", "{CRYPT}");
        options.put("encryption.enabled", "true");
        options.put("encryption.enabled", "true");
        options.put("encryption.algorithm", "MD5");
        options.put("encryption.encoding", "hexadecimal");
        Encryption encryption = null;
        EncryptionSupport encryptionSupport = null;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            options.put(BundleContext.class.getName(), (String)bundle.getBundleContext());
            encryptionSupport = new EncryptionSupport(options);
            encryption = encryptionSupport.getEncryption();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : users.entrySet()) {
            String user = entry.getKey();
            Matcher m = p.matcher(entry.getValue());
            if (!m.matches() || m.groupCount() < 2) continue;
            String password = m.group(1).trim();
            if (!(encryptionSupport == null || encryption == null || password.startsWith(encryptionSupport.getEncryptionPrefix()) && password.endsWith(encryptionSupport.getEncryptionSuffix()))) {
                password = encryptionSupport.getEncryptionPrefix() + encryption.encryptPassword(m.group(1)).trim() + encryptionSupport.getEncryptionSuffix();
            }
            String role = m.group(2).trim();
            sb.append(user).append("=").append(password).append(",").append(role).append("\n");
        }
        String allUsers = sb.toString();
        ZooKeeperUtils.createDefault(curator, "/fabric/authentication/users", allUsers);
        return encryptionSupport;
    }
}

