/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@ThreadSafe
@Component(name="io.fabric8.runtime.properties", immediate=true)
@Service(value={RuntimeProperties.class})
public class RuntimePropertiesService
extends AbstractComponent
implements RuntimeProperties {
    public static final String COMPONENT_NAME = "io.fabric8.runtime.properties";
    private final Map<String, String> systemProperties = new ConcurrentHashMap<String, String>();
    private ComponentContext componentContext;

    @Activate
    void activate(ComponentContext componentContext) throws Exception {
        this.componentContext = componentContext;
        this.assertPropertyNotNull("karaf.home");
        this.assertPropertyNotNull("karaf.base");
        this.assertPropertyNotNull("karaf.name");
        this.assertPropertyNotNull("karaf.data");
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getProperty(String key) {
        this.assertValid();
        return this.getPropertyInternal(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        this.assertValid();
        return this.getPropertyInternal(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.assertValid();
        this.setPropertyInternal(key, value);
    }

    public void removeProperty(String key) {
        this.assertValid();
        this.systemProperties.remove(key);
    }

    private String getPropertyInternal(String key, String defaultValue) {
        String result = this.systemProperties.get(key);
        if (result == null) {
            BundleContext syscontext = this.componentContext.getBundleContext();
            result = syscontext.getProperty(key);
        }
        return result != null ? result : defaultValue;
    }

    private void setPropertyInternal(String key, String value) {
        if (value != null) {
            this.systemProperties.put(key, value);
        }
    }

    private void assertPropertyNotNull(String propName) {
        if (this.getPropertyInternal(propName, null) == null) {
            throw new IllegalStateException("Cannot obtain required property: " + propName);
        }
    }
}

