/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.zookeeper.curator.CuratorFrameworkLocator;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper", description="Fabric ZooKeeper Client Factory", policy=ConfigurationPolicy.OPTIONAL, immediate=true)
public final class ManagedCuratorFramework
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedCuratorFramework.class);
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ACLProvider.class)
    private final ValidatingReference<ACLProvider> aclProvider = new ValidatingReference();
    @Reference(referenceInterface=ConnectionStateListener.class, bind="bindConnectionStateListener", unbind="unbindConnectionStateListener", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    private BundleContext bundleContext;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private AtomicReference<State> state = new AtomicReference();

    @Activate
    void activate(BundleContext bundleContext, Map<String, ?> configuration) throws ConfigurationException {
        State next;
        this.bundleContext = bundleContext;
        String zookeeperURL = this.getZookeeperURL(configuration);
        if (!Strings.isNullOrEmpty((String)zookeeperURL) && this.state.compareAndSet(null, next = new State(configuration))) {
            this.executor.submit(next);
        }
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> configuration) throws ConfigurationException {
        String zookeeperURL = this.getZookeeperURL(configuration);
        if (!Strings.isNullOrEmpty((String)zookeeperURL)) {
            Map<String, ?> oldConfiguration;
            State prev = this.state.get();
            Map<String, ?> map = oldConfiguration = prev != null ? prev.configuration : null;
            if (this.isRestartRequired(oldConfiguration, configuration)) {
                State next = new State(configuration);
                if (this.state.compareAndSet(prev, next)) {
                    this.executor.submit(next);
                    if (prev != null) {
                        prev.close();
                    }
                } else {
                    next.close();
                }
            }
        }
    }

    @Deactivate
    void deactivate() throws IOException {
        this.deactivateComponent();
        State prev = this.state.getAndSet(null);
        if (prev != null) {
            CuratorFrameworkLocator.unbindCurator(prev.curator);
            prev.close();
        }
        this.executor.shutdownNow();
    }

    private String getZookeeperURL(Map<String, ?> configuration) {
        String zookeeperURL = null;
        if (configuration != null) {
            RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
            zookeeperURL = (String)configuration.get("zookeeper.url");
            zookeeperURL = Strings.isNullOrEmpty((String)zookeeperURL) ? sysprops.getProperty("zookeeper.url") : zookeeperURL;
        }
        return zookeeperURL;
    }

    private synchronized CuratorFramework buildCuratorFramework(Map<String, ?> properties) {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String connectionString = ManagedCuratorFramework.readString(properties, "zookeeper.url", sysprops.getProperty("zookeeper.url", ""));
        int sessionTimeoutMs = ManagedCuratorFramework.readInt(properties, "sessionTimeOutMs", 60000);
        int connectionTimeoutMs = ManagedCuratorFramework.readInt(properties, "connectionTimeOutMs", 15000);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().ensembleProvider(new FixedEnsembleProvider(connectionString)).connectionTimeoutMs(connectionTimeoutMs).sessionTimeoutMs(sessionTimeoutMs).retryPolicy(this.buildRetryPolicy(properties));
        if (this.isAuthorizationConfigured(properties)) {
            String scheme = "digest";
            String password = ManagedCuratorFramework.readString(properties, "zookeeper.password", sysprops.getProperty("zookeeper.password", ""));
            byte[] auth = ("fabric:" + password).getBytes();
            builder = builder.authorization(scheme, auth).aclProvider((ACLProvider)this.aclProvider.get());
        }
        CuratorFramework framework = builder.build();
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            framework.getConnectionStateListenable().addListener(listener);
        }
        framework.start();
        return framework;
    }

    private RetryPolicy buildRetryPolicy(Map<String, ?> properties) {
        int maxRetries = ManagedCuratorFramework.readInt(properties, "retryPolicy.maxRetries", 3);
        int intervalMs = ManagedCuratorFramework.readInt(properties, "retryPolicy.retryIntervalMs", 500);
        return new RetryNTimes(maxRetries, intervalMs);
    }

    private boolean isAuthorizationConfigured(Map<String, ?> properties) {
        String zkpass;
        String string = zkpass = properties != null ? (String)properties.get("zookeeper.password") : null;
        if (zkpass == null) {
            zkpass = ((RuntimeProperties)this.runtimeProperties.get()).getProperty("zookeeper.password");
        }
        return !Strings.isNullOrEmpty((String)zkpass);
    }

    private boolean isRestartRequired(Map<String, ?> oldProperties, Map<String, ?> properties) {
        if (!this.propertyEquals(oldProperties, properties, "zookeeper.url")) {
            return true;
        }
        if (!this.propertyEquals(oldProperties, properties, "zookeeper.password")) {
            return true;
        }
        if (!this.propertyEquals(oldProperties, properties, "connectionTimeOutMs")) {
            return true;
        }
        if (!this.propertyEquals(oldProperties, properties, "sessionTimeOutMs")) {
            return true;
        }
        if (!this.propertyEquals(oldProperties, properties, "retryPolicy.maxRetries")) {
            return true;
        }
        return !this.propertyEquals(oldProperties, properties, "retryPolicy.retryIntervalMs");
    }

    private boolean propertyEquals(Map<String, ?> left, Map<String, ?> right, String name) {
        if (left == null || right == null || left.get(name) == null || right.get(name) == null) {
            return !(left != null && left.get(name) != null || right != null && right.get(name) != null);
        }
        return left.get(name).equals(right.get(name));
    }

    private static String readString(Map<String, ?> props, String key, String defaultValue) {
        try {
            Object obj = props.get(key);
            if (obj instanceof String) {
                return (String)obj;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static int readInt(Map<String, ?> props, String key, int defaultValue) {
        try {
            Object obj = props.get(key);
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                return Integer.parseInt((String)obj);
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    void bindConnectionStateListener(ConnectionStateListener connectionStateListener) {
        CuratorFramework curator;
        this.connectionStateListeners.add(connectionStateListener);
        State curr = this.state.get();
        CuratorFramework curatorFramework = curator = curr != null ? curr.curator : null;
        if (curator != null && curator.getZookeeperClient().isConnected()) {
            connectionStateListener.stateChanged(curator, ConnectionState.CONNECTED);
        }
    }

    void unbindConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.remove(connectionStateListener);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindAclProvider(ACLProvider aclProvider) {
        this.aclProvider.bind((Object)aclProvider);
    }

    void unbindAclProvider(ACLProvider aclProvider) {
        this.aclProvider.unbind((Object)aclProvider);
    }

    class State
    implements ConnectionStateListener,
    Runnable {
        final Map<String, ?> configuration;
        final AtomicBoolean closed = new AtomicBoolean();
        ServiceRegistration<CuratorFramework> registration;
        CuratorFramework curator;

        State(Map<String, ?> configuration) {
            this.configuration = configuration;
        }

        @Override
        public void run() {
            if (this.curator != null) {
                this.curator.getZookeeperClient().stop();
            }
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
            try {
                Closeables.close((Closeable)this.curator, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.curator = null;
            if (!this.closed.get()) {
                this.curator = ManagedCuratorFramework.this.buildCuratorFramework(this.configuration);
                this.curator.getConnectionStateListenable().addListener(this, ManagedCuratorFramework.this.executor);
                if (this.curator.getZookeeperClient().isConnected()) {
                    this.stateChanged(this.curator, ConnectionState.CONNECTED);
                }
                CuratorFrameworkLocator.bindCurator(this.curator);
            }
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED && this.registration == null) {
                this.registration = ManagedCuratorFramework.this.bundleContext.registerService(CuratorFramework.class, (Object)this.curator, null);
            }
            for (ConnectionStateListener listener : ManagedCuratorFramework.this.connectionStateListeners) {
                listener.stateChanged(client, newState);
            }
            if (newState == ConnectionState.LOST) {
                this.run();
            }
        }

        public void close() {
            this.closed.set(true);
            CuratorFramework curator = this.curator;
            if (curator != null) {
                curator.getZookeeperClient().stop();
            }
            try {
                ManagedCuratorFramework.this.executor.submit(this).get();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing curator", (Throwable)e);
            }
        }
    }
}

