/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimplePathTemplate {
    private static final Pattern PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private List<String> parameters = new ArrayList<String>();
    private String path;

    public SimplePathTemplate(String path) {
        this.path = path;
        Matcher matcher = PATTERN.matcher(path);
        while (matcher.find()) {
            this.parameters.add(matcher.group(1));
        }
    }

    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String bindByPosition(String ... params) {
        if (params.length != this.parameters.size()) {
            throw new IllegalArgumentException("Parameters mismatch. Path template contains " + this.parameters.size() + " parameters, " + params.length + " was given");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        int j = params.length;
        for (int i = 0; i < j; ++i) {
            String param = params[i];
            if (param != null) {
                param = param.trim();
            }
            paramsMap.put(this.parameters.get(i), param);
        }
        return this.bindByName(paramsMap);
    }

    public String bindByName(String ... params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        int j = params.length;
        for (int i = 0; i < j; i += 2) {
            paramsMap.put(params[i], i + 1 < j ? params[i + 1] : "");
        }
        return this.bindByName(paramsMap);
    }

    public String bindByName(Map<String, String> params) {
        if (params.size() != this.parameters.size()) {
            throw new IllegalArgumentException("Parameters mismatch. Path template contains " + this.parameters.size() + " parameters, " + params.size() + " was given");
        }
        String localPath = this.path;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!this.parameters.contains(key)) {
                throw new IllegalArgumentException("Unknown parameter " + key);
            }
            localPath = this.replace(localPath, key, value);
        }
        return localPath;
    }

    private String replace(String text, String key, String value) {
        if (value == null) {
            throw new IllegalStateException("Parameter " + key + " is null.");
        }
        return text.replace("{" + key + "}", value);
    }
}

