/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric.cf;

import io.fabric8.api.FabricService;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.fusesource.common.util.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={ActiveMQConnectionFactory.class})
@Component(name="org.fusesource.mq.fabric.cf", description="Fabric ActiveMQ Connection Factory Service", immediate=true, configurationFactory=true)
public class ActiveMQConnectionFactoryService
extends ActiveMQConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(ActiveMQConnectionFactoryService.class);
    @Reference(referenceInterface=FabricService.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private FabricService fabricService;

    @Activate
    void activate(Map<String, ?> properties) throws Exception {
        this.updated(properties);
    }

    @Modified
    void updated(Map<String, ?> properties) throws Exception {
        String group = Maps.stringValue(properties, (String)"group", (String)"default");
        String brokerUrl = Maps.stringValue(properties, (String)"brokerUrl");
        if (brokerUrl == null) {
            brokerUrl = "discovery:(fabric:" + group + ")";
        }
        this.setBrokerURL(brokerUrl);
        String user = Maps.stringValue(properties, (String)"user", (String)"admin");
        String password = Maps.stringValue(properties, (String)"password", (String)(this.fabricService != null ? this.fabricService.getZookeeperPassword() : "admin"));
        this.setUserName(user);
        this.setPassword(password);
        LOG.info("Configuring " + (Object)((Object)this) + " with brokerUrl: " + brokerUrl + " and user: " + user);
    }

    @Deactivate
    void deactivate() {
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }
}

