/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.extender;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.extender.ManifestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexKeyManifestFilter
implements ManifestFilter {
    private final Pattern m_pattern;

    public RegexKeyManifestFilter(String regexp) {
        NullArgumentException.validateNotEmpty(regexp, true, "Regular expression");
        this.m_pattern = Pattern.compile(regexp);
    }

    @Override
    public Map<String, String> match(Map<String, String> entries) {
        HashMap<String, String> matching = new HashMap<String, String>();
        if (entries != null && !entries.isEmpty()) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                if (!this.m_pattern.matcher(entry.getKey()).matches()) continue;
                matching.put(entry.getKey(), entry.getValue());
            }
        }
        return matching;
    }
}

