/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleComponentManager<S>
extends AbstractComponentManager<S>
implements ServiceFactory<S> {
    private final AtomicInteger m_useCount = new AtomicInteger();
    private volatile ComponentContextImpl<S> m_componentContext;
    private final ComponentHolder m_componentHolder;
    private Dictionary<String, Object> m_factoryProperties;
    private Dictionary<String, Object> m_properties;
    private Dictionary<String, Object> m_serviceProperties;
    private Dictionary<String, Object> m_configurationProperties;
    private volatile long m_changeCount = -1L;
    private TargetedPID m_targetedPID;
    private final ThreadLocal<Boolean> m_circularReferences = new ThreadLocal();

    public SingleComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
        this(activator, componentHolder, metadata, componentMethods, false);
    }

    public SingleComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods, boolean factoryInstance) {
        super(activator, metadata, componentMethods, factoryInstance);
        this.m_componentHolder = componentHolder;
    }

    @Override
    void clear() {
        if (this.m_componentHolder != null) {
            this.m_componentHolder.disposed(this);
        }
        super.clear();
    }

    @Override
    protected boolean createComponent() {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (createComponent)");
        }
        if (this.m_componentContext == null) {
            S tmpComponent = this.createImplementationObject(null, new SetImplementationObject<S>(){

                @Override
                public void presetComponentContext(ComponentContextImpl<S> componentContext) {
                    SingleComponentManager.this.m_componentContext = componentContext;
                }

                @Override
                public void resetImplementationObject(S implementationObject) {
                    SingleComponentManager.this.m_componentContext = null;
                }
            });
            if (tmpComponent == null) {
                return false;
            }
            this.log(4, "Set implementation object for component {0}", new Object[]{this.getName()}, null);
            BundleComponentActivator activator = this.getActivator();
            if (activator != null) {
                activator.missingServicePresent(this.getServiceReference());
            }
        }
        return true;
    }

    @Override
    protected void deleteComponent(int reason) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        if (this.m_componentContext != null) {
            this.m_useCount.set(0);
            this.disposeImplementationObject(this.m_componentContext, reason);
            this.m_componentContext = null;
            this.log(4, "Unset and deconfigured implementation object for component {0} in deleteComponent for reason {1}", new Object[]{this.getName(), REASONS[reason]}, null);
            this.clearServiceProperties();
        }
    }

    void clearServiceProperties() {
        this.m_properties = null;
        this.m_serviceProperties = null;
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return this.m_componentContext == null ? null : this.m_componentContext.getComponentInstance();
    }

    S getInstance() {
        return this.m_componentContext == null ? null : (S)this.m_componentContext.getImplementationObject(true);
    }

    protected S createImplementationObject(Bundle usingBundle, SetImplementationObject setter) {
        Object implementationObject;
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            this.log(2, "Bundle shut down during instantiation of the implementation object", null);
            return null;
        }
        try {
            Class implementationObjectClass = bundle.loadClass(this.getComponentMetadata().getImplementationClassName());
            implementationObject = implementationObjectClass.newInstance();
        }
        catch (Throwable t) {
            this.log(1, "Error during instantiation of the implementation object", t);
            return null;
        }
        ComponentContextImpl componentContext = new ComponentContextImpl(this, usingBundle, implementationObject);
        setter.presetComponentContext(componentContext);
        DependencyManager failedDm = null;
        for (DependencyManager dependencyManager : this.getDependencyManagers()) {
            if (failedDm == null) {
                boolean bl = dependencyManager.open(implementationObject, componentContext.getEdgeInfo(dependencyManager));
                if (bl) continue;
                this.log(1, "Cannot create component instance due to failure to bind reference {0}", new Object[]{dependencyManager.getName()}, null);
                failedDm = dependencyManager;
                continue;
            }
            componentContext.getEdgeInfo(dependencyManager).ignore();
        }
        if (failedDm != null) {
            boolean skip = true;
            for (DependencyManager dependencyManager : this.getReversedDependencyManagers()) {
                if (skip && failedDm == dependencyManager) {
                    skip = false;
                }
                if (!skip) {
                    dependencyManager.close(implementationObject, componentContext.getEdgeInfo(dependencyManager));
                }
                dependencyManager.deactivate();
            }
            setter.resetImplementationObject(implementationObject);
            this.unsetDependenciesCollected();
            return null;
        }
        MethodResult result = this.getComponentMethods().getActivateMethod().invoke(implementationObject, new ActivateMethod.ActivatorParameter(componentContext, 1), null, this);
        if (result == null) {
            for (DependencyManager dependencyManager : this.getReversedDependencyManagers()) {
                dependencyManager.close(implementationObject, componentContext.getEdgeInfo(dependencyManager));
            }
            setter.resetImplementationObject(implementationObject);
            return null;
        }
        componentContext.setImplementationAccessible(true);
        this.m_circularReferences.remove();
        this.setServiceProperties(result);
        return (S)implementationObject;
    }

    protected void disposeImplementationObject(ComponentContextImpl<S> componentContext, int reason) {
        componentContext.setImplementationAccessible(false);
        S implementationObject = componentContext.getImplementationObject(false);
        if (implementationObject != null) {
            MethodResult result = this.getComponentMethods().getDeactivateMethod().invoke(implementationObject, new ActivateMethod.ActivatorParameter(componentContext, reason), null, this);
            if (result != null) {
                this.setServiceProperties(result);
            }
            for (DependencyManager<S, ?> md : this.getReversedDependencyManagers()) {
                md.close(implementationObject, componentContext.getEdgeInfo(md));
            }
        }
    }

    @Override
    boolean hasInstance() {
        return this.m_componentContext != null;
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<T> refPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            S impl = componentContext.getImplementationObject(false);
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeBindMethod(impl, refPair, trackingCount, info);
        }
    }

    @Override
    <T> void invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<T> refPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            S impl = componentContext.getImplementationObject(false);
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeUpdatedMethod(impl, refPair, trackingCount, info);
        }
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<T> oldRefPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            S impl = componentContext.getImplementationObject(false);
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeUnbindMethod(impl, oldRefPair, trackingCount, info);
        }
    }

    protected void setFactoryProperties(Dictionary<String, Object> dictionary) {
        this.m_factoryProperties = SingleComponentManager.copyTo(null, dictionary);
    }

    @Override
    public boolean hasConfiguration() {
        return this.m_configurationProperties != null;
    }

    @Override
    void registerComponentId() {
        super.registerComponentId();
        this.m_properties = null;
    }

    @Override
    void unregisterComponentId() {
        super.unregisterComponentId();
        this.m_properties = null;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        if (this.m_properties == null) {
            Dictionary<String, Object> props = SingleComponentManager.copyTo(null, this.getComponentMetadata().getProperties());
            for (ReferenceMetadata rm : this.getComponentMetadata().getDependencies()) {
                if (rm.getTarget() == null) continue;
                props.put(rm.getTargetPropertyName(), rm.getTarget());
            }
            SingleComponentManager.copyTo(props, this.m_configurationProperties);
            SingleComponentManager.copyTo(props, this.m_factoryProperties);
            props.put("component.name", this.getComponentMetadata().getName());
            props.put("component.id", this.getId());
            this.m_properties = props;
        }
        return this.m_properties;
    }

    @Override
    public void setServiceProperties(Dictionary<String, Object> serviceProperties) {
        if (serviceProperties == null || serviceProperties.isEmpty()) {
            this.m_serviceProperties = null;
        } else {
            this.m_serviceProperties = SingleComponentManager.copyTo(null, serviceProperties, false);
            this.m_serviceProperties.put("component.name", this.getComponentMetadata().getName());
            this.m_serviceProperties.put("component.id", this.getId());
        }
        this.updateServiceRegistration();
    }

    @Override
    public Dictionary<String, Object> getServiceProperties() {
        if (this.m_serviceProperties != null) {
            return this.m_serviceProperties;
        }
        return super.getServiceProperties();
    }

    private void updateServiceRegistration() {
        ServiceRegistration sr = this.getServiceRegistration();
        if (sr != null) {
            try {
                Dictionary<String, Object> regProps = this.getServiceProperties();
                if (!this.servicePropertiesMatches(sr, regProps)) {
                    sr.setProperties(regProps);
                }
            }
            catch (IllegalStateException ise) {
            }
            catch (IllegalArgumentException iae) {
                this.log(1, "Unexpected configuration property problem when updating service registration", iae);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem when updating service registration", t);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void reconfigure(Dictionary<String, Object> configuration, long changeCount, TargetedPID targetedPID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK], 5[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modify() {
        MethodResult result;
        block9: {
            block8: {
                boolean bl;
                if (this.getComponentMetadata().getModified() == null) {
                    this.log(4, "No modified method, cannot update dynamically", null);
                    return false;
                }
                Dictionary<String, Object> props = this.getProperties();
                for (DependencyManager dm : this.getDependencyManagers()) {
                    if (dm.canUpdateDynamically(props)) continue;
                    this.log(4, "Cannot dynamically update the configuration due to dependency changes induced on dependency {0}", new Object[]{dm.getName()}, null);
                    return false;
                }
                this.obtainStateLock("ImmediateComponentManager.modify");
                try {
                    result = this.invokeModifiedMethod();
                    this.updateTargets(props);
                    if (result != null) break block8;
                    this.log(1, "Declared modify method ''{0}'' cannot be found, configuring by reactivation", new Object[]{this.getComponentMetadata().getModified()}, null);
                    bl = false;
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    this.releaseStateLock("ImmediateComponentManager.modify");
                    throw throwable;
                }
                this.releaseStateLock("ImmediateComponentManager.modify");
                return bl;
            }
            if (this.verifyDependencyManagers()) break block9;
            this.log(1, "Updating the service references caused at least on reference to become unsatisfied, deactivating component", null);
            boolean bl = false;
            Object var5_8 = null;
            this.releaseStateLock("ImmediateComponentManager.modify");
            return bl;
        }
        if (result.hasResult()) {
            this.setServiceProperties(result);
        } else {
            this.updateServiceRegistration();
        }
        boolean bl = true;
        Object var5_9 = null;
        this.releaseStateLock("ImmediateComponentManager.modify");
        return bl;
    }

    protected MethodResult invokeModifiedMethod() {
        ModifiedMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        if (this.getInstance() != null) {
            return modifiedMethod.invoke(this.getInstance(), new ActivateMethod.ActivatorParameter(this.m_componentContext, -1), MethodResult.VOID, this);
        }
        return MethodResult.VOID;
    }

    private boolean servicePropertiesMatches(ServiceRegistration reg, Dictionary<String, Object> props) {
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        String[] keys = reg.getReference().getPropertyKeys();
        for (int i = 0; keys != null && i < keys.length; ++i) {
            if (keys[i].equals("objectClass") || keys[i].equals("service.id")) continue;
            ((Dictionary)regProps).put(keys[i], reg.getReference().getProperty(keys[i]));
        }
        return ((Object)regProps).equals(props);
    }

    public S getService(Bundle bundle, ServiceRegistration<S> serviceRegistration) {
        boolean success = this.getServiceInternal();
        if (success) {
            this.m_useCount.incrementAndGet();
            return this.m_componentContext.getImplementationObject(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean getServiceInternal() {
        if (this.m_circularReferences.get() != null) {
            this.log(1, "Circular reference detected, getService returning null", null);
            this.dumpThreads();
            return false;
        }
        this.m_circularReferences.set(Boolean.TRUE);
        try {
            boolean success = true;
            if (this.m_componentContext == null) {
                try {
                    if (!this.collectDependencies()) {
                        this.log(4, "getService did not win collecting dependencies, try creating object anyway.", null);
                    } else {
                        this.log(4, "getService won collecting dependencies, proceed to creating object.", null);
                    }
                }
                catch (IllegalStateException e) {
                    this.log(3, "Could not obtain all required dependencies, getService returning null", null);
                    success = false;
                }
                this.obtainStateLock("ImmediateComponentManager.getService.1");
                try {
                    if (this.m_componentContext == null) {
                        S result = this.getService();
                        if (result == null) {
                            success = false;
                        } else {
                            this.m_activated = true;
                        }
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.releaseStateLock("ImmediateComponentManager.getService.1");
                    throw throwable;
                }
                this.releaseStateLock("ImmediateComponentManager.getService.1");
                {
                }
            }
            boolean bl = success;
            Object var6_8 = null;
            this.m_circularReferences.remove();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.m_circularReferences.remove();
            throw throwable;
        }
    }

    private S getService() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.createComponent()) {
            return this.getInstance();
        }
        this.log(1, "Failed creating the component instance; see log for reason", null);
        try {
            this.deleteComponent(0);
        }
        catch (Throwable t) {
            this.log(4, "Cannot delete incomplete component instance. Ignoring.", t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration<S> serviceRegistration, S o) {
        int useCount;
        if (this.m_useCount.get() > 0 && (useCount = this.m_useCount.decrementAndGet()) == 0 && !this.isImmediate() && !this.keepInstances()) {
            this.obtainStateLock("ImmediateComponentManager.ungetService.1");
            try {
                if (this.m_useCount.get() == 0) {
                    this.ungetService();
                    this.unsetDependenciesCollected();
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.releaseStateLock("ImmediateComponentManager.ungetService.1");
                throw throwable;
            }
            this.releaseStateLock("ImmediateComponentManager.ungetService.1");
            {
            }
        }
    }

    void ungetService() {
        this.deleteComponent(0);
    }

    private boolean keepInstances() {
        return this.getActivator() != null && this.getActivator().getConfiguration().keepInstances();
    }

    public long getChangeCount() {
        return this.m_changeCount;
    }

    public TargetedPID getConfigurationTargetedPID() {
        return this.m_targetedPID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface SetImplementationObject<S> {
        public void presetComponentContext(ComponentContextImpl<S> var1);

        public void resetImplementationObject(S var1);
    }
}

