/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class FabricCommand
extends OsgiCommandSupport {
    private CuratorFramework curator;
    protected FabricService fabricService;
    protected ConfigurationAdmin configurationAdmin;

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void checkFabricAvailable() throws Exception {
    }

    protected String toString(Profile[] profiles) {
        if (profiles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < profiles.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(profiles[i].getId());
        }
        return sb.toString();
    }

    protected String toString(Iterable<String> profiles) {
        if (profiles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String profile : profiles) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(profile);
            first = false;
        }
        return sb.toString();
    }

    protected Profile[] getProfiles(String version, List<String> names) {
        return this.getProfiles(this.fabricService.getVersion(version), names);
    }

    protected Profile[] getProfiles(Version version, List<String> names) {
        Profile[] allProfiles = version.getProfiles();
        ArrayList<Object> profiles = new ArrayList<Object>();
        if (names == null) {
            return new Profile[0];
        }
        for (String name : names) {
            Profile profile = null;
            for (Profile p : allProfiles) {
                if (!name.equals(p.getId())) continue;
                profile = p;
                break;
            }
            if (profile == null) {
                profiles.add(new ProfileImpl(name, version.getId(), this.fabricService));
            }
            profiles.add(profile);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    protected Profile getProfile(Version ver, String name) {
        Profile p = ver.getProfile(name);
        if (p == null) {
            throw new IllegalArgumentException("Profile " + name + " does not exist.");
        }
        return p;
    }

    protected boolean isPartOfEnsemble(String containerName) {
        boolean result = false;
        Container container = this.fabricService.getContainer(containerName);
        try {
            ArrayList containerList = new ArrayList();
            String clusterId = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
            String containers = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{clusterId}));
            Collections.addAll(containerList, containers.split(","));
            result = containerList.contains(containerName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return result;
    }

    protected Container getContainer(String name) {
        Container[] containers;
        for (Container container : containers = this.fabricService.getContainers()) {
            if (!container.getId().equals(name)) continue;
            return container;
        }
        throw new IllegalArgumentException("Container " + name + " does not exist.");
    }

    protected boolean doesContainerExist(String name) {
        Container[] containers;
        for (Container container : containers = this.fabricService.getContainers()) {
            if (!container.getId().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String percentText(double value) {
        return NumberFormat.getPercentInstance().format(value);
    }
}

