/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.TrackingMergeScheduler;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.store.XFSIndexOutput;
import org.elasticsearch.common.RateLimiter;

public class XNIOFSDirectory
extends NIOFSDirectory {
    private final StoreRateLimiting.Provider rateLimitingProvider;
    private final StoreRateLimiting.Listener rateListener;

    public XNIOFSDirectory(File path, LockFactory lockFactory, StoreRateLimiting.Provider rateLimitingProvider, StoreRateLimiting.Listener rateListener) throws IOException {
        super(path, lockFactory);
        this.rateLimitingProvider = rateLimitingProvider;
        this.rateListener = rateListener;
    }

    @Override
    public IndexOutput createOutput(String name) throws IOException {
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return super.createOutput(name);
        }
        if (TrackingMergeScheduler.getCurrentMerge() != null) {
            this.ensureOpen();
            this.ensureCanWrite(name);
            return new XFSIndexOutput(this, name, limiter, this.rateListener);
        }
        if (type == StoreRateLimiting.Type.ALL) {
            this.ensureOpen();
            this.ensureCanWrite(name);
            return new XFSIndexOutput(this, name, limiter, this.rateListener);
        }
        return super.createOutput(name);
    }
}

