/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesShutdownResponse
extends ActionResponse {
    private ClusterName clusterName;
    private DiscoveryNode[] nodes;

    NodesShutdownResponse() {
    }

    public NodesShutdownResponse(ClusterName clusterName, DiscoveryNode[] nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    public ClusterName clusterName() {
        return this.clusterName;
    }

    public ClusterName getClusterName() {
        return this.clusterName();
    }

    public DiscoveryNode[] nodes() {
        return this.nodes;
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = ClusterName.readClusterName(in);
        this.nodes = new DiscoveryNode[in.readVInt()];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = DiscoveryNode.readNode(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        out.writeVInt(this.nodes.length);
        for (DiscoveryNode node : this.nodes) {
            node.writeTo(out);
        }
    }
}

