/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.delete;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.warmer.IndexWarmerMissingException;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteWarmerAction
extends TransportMasterNodeOperationAction<DeleteWarmerRequest, DeleteWarmerResponse> {
    @Inject
    public TransportDeleteWarmerAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/warmer/delete";
    }

    @Override
    protected DeleteWarmerRequest newRequest() {
        return new DeleteWarmerRequest();
    }

    @Override
    protected DeleteWarmerResponse newResponse() {
        return new DeleteWarmerResponse();
    }

    @Override
    protected void doExecute(DeleteWarmerRequest request, ActionListener<DeleteWarmerResponse> listener) {
        request.indices(this.clusterService.state().metaData().concreteIndices(request.indices()));
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteWarmerRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, request.indices());
    }

    @Override
    protected DeleteWarmerResponse masterOperation(final DeleteWarmerRequest request, ClusterState state) throws ElasticSearchException {
        final AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final CountDownLatch latch = new CountDownLatch(1);
        this.clusterService.submitStateUpdateTask("delete_warmer [" + request.name() + "]", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                try {
                    IndexWarmersMetaData warmers;
                    IndexMetaData indexMetaData;
                    MetaData.Builder mdBuilder = MetaData.builder().metaData(currentState.metaData());
                    boolean globalFoundAtLeastOne = false;
                    for (String index : request.indices()) {
                        indexMetaData = currentState.metaData().index(index);
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(index));
                        }
                        warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                        if (warmers == null) continue;
                        ArrayList<IndexWarmersMetaData.Entry> entries = Lists.newArrayList();
                        for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                            if (request.name() == null || Regex.simpleMatch(request.name(), entry.name())) {
                                globalFoundAtLeastOne = true;
                                continue;
                            }
                            entries.add(entry);
                        }
                        if (entries.size() == warmers.entries().size()) continue;
                        warmers = new IndexWarmersMetaData(entries.toArray(new IndexWarmersMetaData.Entry[entries.size()]));
                        IndexMetaData.Builder indexBuilder = IndexMetaData.newIndexMetaDataBuilder(indexMetaData).putCustom("warmers", warmers);
                        mdBuilder.put(indexBuilder);
                    }
                    if (!globalFoundAtLeastOne) {
                        if (request.name() == null) {
                            return currentState;
                        }
                        throw new IndexWarmerMissingException(request.name());
                    }
                    if (TransportDeleteWarmerAction.this.logger.isInfoEnabled()) {
                        for (String index : request.indices()) {
                            indexMetaData = currentState.metaData().index(index);
                            if (indexMetaData == null) {
                                throw new IndexMissingException(new Index(index));
                            }
                            warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                            if (warmers == null) continue;
                            for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                                if (!Regex.simpleMatch(request.name(), entry.name())) continue;
                                TransportDeleteWarmerAction.this.logger.info("[{}] delete warmer [{}]", index, entry.name());
                            }
                        }
                    }
                    return ClusterState.builder().state(currentState).metaData(mdBuilder).build();
                }
                catch (Exception ex) {
                    failureRef.set(ex);
                    latch.countDown();
                    return currentState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return new DeleteWarmerResponse(true);
    }
}

