/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchShardTarget;

public class ShardSearchFailure
implements ShardOperationFailedException {
    public static final ShardSearchFailure[] EMPTY_ARRAY = new ShardSearchFailure[0];
    private SearchShardTarget shardTarget;
    private String reason;
    private RestStatus status;

    private ShardSearchFailure() {
    }

    public ShardSearchFailure(Throwable t) {
        Throwable actual = ExceptionsHelper.unwrapCause(t);
        if (actual != null && actual instanceof SearchException) {
            this.shardTarget = ((SearchException)actual).shard();
        }
        this.status = actual != null && actual instanceof ElasticSearchException ? ((ElasticSearchException)actual).status() : RestStatus.INTERNAL_SERVER_ERROR;
        this.reason = ExceptionsHelper.detailedMessage(t);
    }

    public ShardSearchFailure(String reason, SearchShardTarget shardTarget) {
        this.shardTarget = shardTarget;
        this.reason = reason;
        this.status = RestStatus.INTERNAL_SERVER_ERROR;
    }

    @Nullable
    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    public RestStatus status() {
        return this.status;
    }

    @Override
    public String index() {
        if (this.shardTarget != null) {
            return this.shardTarget.index();
        }
        return null;
    }

    @Override
    public int shardId() {
        if (this.shardTarget != null) {
            return this.shardTarget.shardId();
        }
        return -1;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public String toString() {
        return "shard [" + (this.shardTarget == null ? "_na" : this.shardTarget) + "], reason [" + this.reason + "]";
    }

    public static ShardSearchFailure readShardSearchFailure(StreamInput in) throws IOException {
        ShardSearchFailure shardSearchFailure = new ShardSearchFailure();
        shardSearchFailure.readFrom(in);
        return shardSearchFailure;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.shardTarget = SearchShardTarget.readSearchShardTarget(in);
        }
        this.reason = in.readUTF();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.shardTarget == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.shardTarget.writeTo(out);
        }
        out.writeUTF(this.reason);
        RestStatus.writeTo(out, this.status);
    }
}

