/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class ShardReplicationOperationRequest<T extends ShardReplicationOperationRequest>
extends ActionRequest<T> {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    private boolean threadedOperation = true;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;

    protected ShardReplicationOperationRequest() {
    }

    public ShardReplicationOperationRequest(ActionRequest request) {
        super(request);
    }

    public ShardReplicationOperationRequest(T request) {
        super((ActionRequest)request);
        this.timeout = ((ShardReplicationOperationRequest)request).timeout();
        this.index = ((ShardReplicationOperationRequest)request).index();
        this.threadedOperation = ((ShardReplicationOperationRequest)request).operationThreaded();
        this.replicationType = ((ShardReplicationOperationRequest)request).replicationType();
        this.consistencyLevel = ((ShardReplicationOperationRequest)request).consistencyLevel();
    }

    public final boolean operationThreaded() {
        return this.threadedOperation;
    }

    public final T operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return (T)this;
    }

    public final T timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public final T timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public String index() {
        return this.index;
    }

    public final T index(String index) {
        this.index = index;
        return (T)this;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public final T replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return (T)this;
    }

    public final T replicationType(String replicationType) {
        return this.replicationType(ReplicationType.fromString(replicationType));
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public final T consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return (T)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.timeout = TimeValue.readTimeValue(in);
        this.index = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        this.timeout.writeTo(out);
        out.writeString(this.index);
    }

    public void beforeLocalFork() {
    }
}

