/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.text.StringAndBytesText;
import org.elasticsearch.common.text.Text;

public abstract class StreamInput
extends InputStream {
    private Version version = Version.CURRENT;

    public Version getVersion() {
        return this.version;
    }

    public StreamInput setVersion(Version version) {
        this.version = version;
        return this;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readVInt();
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | ((long)b & 0x7FL) << 56;
    }

    @Nullable
    @Deprecated
    public String readOptionalUTF() throws IOException {
        if (this.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return new StringAndBytesText(this.readBytesReference(length));
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    public String readString() throws IOException {
        int charCount = this.readVInt();
        char[] chars = CachedStreamInput.getCharArray(charCount);
        int charIndex = 0;
        while (charIndex < charCount) {
            int c = this.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    chars[charIndex++] = (char)((c & 0x1F) << 6 | this.readByte() & 0x3F);
                    break;
                }
                case 14: {
                    chars[charIndex++] = (char)((c & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | (this.readByte() & 0x3F) << 0);
                }
            }
        }
        return new String(chars, 0, charCount);
    }

    @Deprecated
    public String readUTF() throws IOException {
        return this.readString();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public abstract void reset() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public String[] readStringArray() throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readLong();
            }
            case 3: {
                return Float.valueOf(this.readFloat());
            }
            case 4: {
                return this.readDouble();
            }
            case 5: {
                return this.readBoolean();
            }
            case 6: {
                int bytesSize = this.readVInt();
                byte[] value = new byte[bytesSize];
                this.readBytes(value, 0, bytesSize);
                return value;
            }
            case 7: {
                int size = this.readVInt();
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.readGenericValue());
                }
                return list;
            }
            case 8: {
                int size8 = this.readVInt();
                Object[] list8 = new Object[size8];
                for (int i = 0; i < size8; ++i) {
                    list8[i] = this.readGenericValue();
                }
                return list8;
            }
            case 9: {
                int size9 = this.readVInt();
                LinkedHashMap<String, Object> map9 = new LinkedHashMap<String, Object>(size9);
                for (int i = 0; i < size9; ++i) {
                    map9.put(this.readString(), this.readGenericValue());
                }
                return map9;
            }
            case 10: {
                int size10 = this.readVInt();
                HashMap<String, Object> map10 = new HashMap<String, Object>(size10);
                for (int i = 0; i < size10; ++i) {
                    map10.put(this.readString(), this.readGenericValue());
                }
                return map10;
            }
            case 11: {
                return this.readByte();
            }
            case 12: {
                return new Date(this.readLong());
            }
            case 13: {
                return new DateTime(this.readLong());
            }
            case 14: {
                return this.readBytesReference();
            }
            case 15: {
                return this.readText();
            }
            case 16: {
                return this.readShort();
            }
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }
}

