/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocSet;

public class AndDocSet
extends DocSet {
    private final List<DocSet> sets;

    public AndDocSet(List<DocSet> sets) {
        this.sets = sets;
    }

    @Override
    public boolean get(int doc) {
        for (DocSet s : this.sets) {
            if (s.get(doc)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        if (this.sets.isEmpty()) {
            return 0;
        }
        return this.sets.get(0).length();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (DocSet set : this.sets) {
            sizeInBytes += set.sizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new AndDocIdSetIterator();
    }

    class AndDocIdSetIterator
    extends DocIdSetIterator {
        int lastReturn = -1;
        private DocIdSetIterator[] iterators = null;

        AndDocIdSetIterator() throws IOException {
            this.iterators = new DocIdSetIterator[AndDocSet.this.sets.size()];
            int j = 0;
            for (DocSet set : AndDocSet.this.sets) {
                if (set == null) {
                    this.lastReturn = Integer.MAX_VALUE;
                    break;
                }
                DocIdSetIterator dcit = set.iterator();
                if (dcit == null) {
                    this.lastReturn = Integer.MAX_VALUE;
                    break;
                }
                this.iterators[j++] = dcit;
            }
            if (this.lastReturn != Integer.MAX_VALUE) {
                this.lastReturn = this.iterators.length > 0 ? -1 : Integer.MAX_VALUE;
            }
        }

        @Override
        public final int docID() {
            return this.lastReturn;
        }

        @Override
        public final int nextDoc() throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            int target = dcit.nextDoc();
            int size = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        @Override
        public final int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            target = dcit.advance(target);
            int size = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }
    }
}

