/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;

public class NotDeletedFilter
extends Filter {
    private final Filter filter;

    public NotDeletedFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet docIdSet = this.filter.getDocIdSet(reader);
        if (docIdSet == null) {
            return null;
        }
        if (!reader.hasDeletions()) {
            return docIdSet;
        }
        return new NotDeletedDocIdSet(docIdSet, reader);
    }

    public Filter filter() {
        return this.filter;
    }

    public String toString() {
        return "NotDeleted(" + this.filter + ")";
    }

    static class NotDeletedDocIdSetIterator
    extends FilteredDocIdSetIterator {
        private final IndexReader reader;

        NotDeletedDocIdSetIterator(DocIdSetIterator innerIter, IndexReader reader) {
            super(innerIter);
            this.reader = reader;
        }

        @Override
        protected boolean match(int doc) throws IOException {
            return !this.reader.isDeleted(doc);
        }
    }

    static class NotDeletedDocIdSet
    extends DocIdSet {
        private final DocIdSet innerSet;
        private final IndexReader reader;

        NotDeletedDocIdSet(DocIdSet innerSet, IndexReader reader) {
            this.innerSet = innerSet;
            this.reader = reader;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            DocIdSetIterator iterator = this.innerSet.iterator();
            if (iterator == null) {
                return null;
            }
            return new NotDeletedDocIdSetIterator(iterator, this.reader);
        }
    }
}

