/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelException;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelFutureProgressListener;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.internal.DeadLockProofWorker;

public class DefaultChannelFuture
implements ChannelFuture {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelFuture.class);
    private static final Throwable CANCELLED = new Throwable();
    private static volatile boolean useDeadLockChecker = true;
    private static boolean disabledDeadLockCheckerOnce;
    private final Channel channel;
    private final boolean cancellable;
    private ChannelFutureListener firstListener;
    private List<ChannelFutureListener> otherListeners;
    private List<ChannelFutureProgressListener> progressListeners;
    private boolean done;
    private Throwable cause;
    private int waiters;

    public static boolean isUseDeadLockChecker() {
        return useDeadLockChecker;
    }

    public static void setUseDeadLockChecker(boolean useDeadLockChecker) {
        if (!useDeadLockChecker && !disabledDeadLockCheckerOnce) {
            disabledDeadLockCheckerOnce = true;
            if (logger.isDebugEnabled()) {
                logger.debug("The dead lock checker in " + DefaultChannelFuture.class.getSimpleName() + " has been disabled as requested at your own risk.");
            }
        }
        DefaultChannelFuture.useDeadLockChecker = useDeadLockChecker;
    }

    public DefaultChannelFuture(Channel channel, boolean cancellable) {
        this.channel = channel;
        this.cancellable = cancellable;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean isSuccess() {
        return this.done && this.cause == null;
    }

    public synchronized Throwable getCause() {
        if (this.cause != CANCELLED) {
            return this.cause;
        }
        return null;
    }

    public synchronized boolean isCancelled() {
        return this.cause == CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                notifyNow = true;
            } else {
                if (this.firstListener == null) {
                    this.firstListener = listener;
                } else {
                    if (this.otherListeners == null) {
                        this.otherListeners = new ArrayList<ChannelFutureListener>(1);
                    }
                    this.otherListeners.add(listener);
                }
                if (listener instanceof ChannelFutureProgressListener) {
                    if (this.progressListeners == null) {
                        this.progressListeners = new ArrayList<ChannelFutureProgressListener>(1);
                    }
                    this.progressListeners.add((ChannelFutureProgressListener)listener);
                }
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (!this.done) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
                if (listener instanceof ChannelFutureProgressListener) {
                    this.progressListeners.remove(listener);
                }
            }
        }
    }

    @Deprecated
    public ChannelFuture rethrowIfFailed() throws Exception {
        if (!this.isDone()) {
            return this;
        }
        Throwable cause = this.getCause();
        if (cause == null) {
            return this;
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new RuntimeException(cause);
    }

    public ChannelFuture sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed0();
        return this;
    }

    public ChannelFuture syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed0();
        return this;
    }

    private void rethrowIfFailed0() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new ChannelException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            while (!this.done) {
                Object var3_2;
                DefaultChannelFuture.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                    var3_2 = null;
                    --this.waiters;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
        }
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ChannelFuture awaitUninterruptibly() {
        boolean interrupted = false;
        DefaultChannelFuture defaultChannelFuture = this;
        // MONITORENTER : defaultChannelFuture
        while (true) {
            Object var5_4;
            if (this.done) {
                // MONITOREXIT : defaultChannelFuture
                if (!interrupted) return this;
                Thread.currentThread().interrupt();
                return this;
            }
            DefaultChannelFuture.checkDeadLock();
            ++this.waiters;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    var5_4 = null;
                    --this.waiters;
                    continue;
                }
                var5_4 = null;
                --this.waiters;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                --this.waiters;
                throw throwable;
            }
        }
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        block18: {
            block17: {
                if (interruptable && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                startTime = timeoutNanos <= 0L ? 0L : System.nanoTime();
                waitTime = timeoutNanos;
                interrupted = false;
                try {
                    var9_6 = this;
                    synchronized (var9_6) {
                        if (this.done || waitTime <= 0L) {
                            var10_7 = this.done;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 15] lbl11 : MonitorExitStatement: MONITOREXIT : var9_6
                            var15_11 = null;
                            if (interrupted == false) return var10_7;
                            Thread.currentThread().interrupt();
                            return var10_7;
                        }
                        DefaultChannelFuture.checkDeadLock();
                        ++this.waiters;
                        while (true) {
                            try {
                                try {
                                    this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                                }
                                catch (InterruptedException e) {
                                    if (interruptable) {
                                        throw e;
                                    }
                                    interrupted = true;
                                }
                                if (!this.done) continue;
                                var10_9 = true;
                                var12_15 = null;
                                --this.waiters;
                                break block17;
                            }
                            catch (Throwable var11_18) {
                                var12_17 = null;
                                --this.waiters;
                                throw var11_18;
                            }
                            break;
                        }
                        {
                            if ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L) ** continue;
                            var10_10 = this.done;
                            var12_16 = null;
                            --this.waiters;
                        }
                    }
                    break block18;
                }
                catch (Throwable var14_19) {
                    var15_14 = null;
                    if (interrupted == false) throw var14_19;
                    Thread.currentThread().interrupt();
                    throw var14_19;
                }
            }
            var15_12 = null;
            if (interrupted == false) return var10_9;
            Thread.currentThread().interrupt();
            return var10_9;
        }
        var15_13 = null;
        if (interrupted == false) return var10_10;
        Thread.currentThread().interrupt();
        return var10_10;
    }

    private static void checkDeadLock() {
        if (DefaultChannelFuture.isUseDeadLockChecker() && DeadLockProofWorker.PARENT.get() != null) {
            throw new IllegalStateException("await*() in I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSuccess() {
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFailure(Throwable cause) {
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            this.cause = cause;
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (!this.cancellable) {
            return false;
        }
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            this.cause = CANCELLED;
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (ChannelFutureListener l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(ChannelFutureListener l) {
        block2: {
            try {
                l.operationComplete(this);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + ChannelFutureListener.class.getSimpleName() + '.', t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProgress(long amount, long current, long total) {
        ChannelFutureProgressListener[] plisteners;
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            List<ChannelFutureProgressListener> progressListeners = this.progressListeners;
            if (progressListeners == null || progressListeners.isEmpty()) {
                return true;
            }
            plisteners = progressListeners.toArray(new ChannelFutureProgressListener[progressListeners.size()]);
        }
        for (ChannelFutureProgressListener pl : plisteners) {
            this.notifyProgressListener(pl, amount, current, total);
        }
        return true;
    }

    private void notifyProgressListener(ChannelFutureProgressListener l, long amount, long current, long total) {
        block2: {
            try {
                l.operationProgressed(this, amount, current, total);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + ChannelFutureProgressListener.class.getSimpleName() + '.', t);
            }
        }
    }
}

