/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MatchQuery {
    protected final QueryParseContext parseContext;
    protected String analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected String fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = Integer.MAX_VALUE;
    protected MultiTermQuery.RewriteMethod rewriteMethod;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient;
    protected ZeroTermsQuery zeroTermsQuery = ZeroTermsQuery.NONE;

    public MatchQuery(QueryParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(String fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    public Query parse(Type type, String fieldName, String text) {
        TokenStream source;
        Term fieldTerm;
        FieldMapper mapper = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = this.parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            mapper = smartNameFieldMappers.mapper();
            fieldTerm = mapper.names().indexNameTerm();
        } else {
            fieldTerm = new Term(fieldName);
        }
        if (mapper != null && mapper.useFieldQueryWithQueryString()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    Query query = QueryParsers.wrapSmartNameQuery(mapper.fieldQuery(text, this.parseContext), smartNameFieldMappers, this.parseContext);
                    return query;
                }
                catch (RuntimeException e) {
                    if (this.lenient) {
                        Query query = null;
                        return query;
                    }
                    throw e;
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            }
            try {
                return QueryParsers.wrapSmartNameQuery(mapper.fieldQuery(text, this.parseContext), smartNameFieldMappers, this.parseContext);
            }
            catch (RuntimeException e) {
                if (this.lenient) {
                    return null;
                }
                throw e;
            }
        }
        Analyzer analyzer = null;
        if (this.analyzer == null) {
            if (mapper != null) {
                analyzer = mapper.searchAnalyzer();
            }
            if (analyzer == null && smartNameFieldMappers != null) {
                analyzer = smartNameFieldMappers.searchAnalyzer();
            }
            if (analyzer == null) {
                analyzer = this.parseContext.mapperService().searchAnalyzer();
            }
        } else {
            analyzer = this.parseContext.mapperService().analysisService().analyzer(this.analyzer);
            if (analyzer == null) {
                throw new ElasticSearchIllegalArgumentException("No analyzer found for [" + this.analyzer + "]");
            }
        }
        try {
            source = analyzer.reusableTokenStream(fieldTerm.field(), new FastStringReader(text));
            source.reset();
        }
        catch (IOException e) {
            source = analyzer.tokenStream(fieldTerm.field(), new FastStringReader(text));
        }
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        CharTermAttribute termAtt = null;
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        boolean success = false;
        try {
            buffer.reset();
            success = true;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (success) {
            if (buffer.hasAttribute(CharTermAttribute.class)) {
                termAtt = buffer.getAttribute(CharTermAttribute.class);
            }
            if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                posIncrAtt = buffer.getAttribute(PositionIncrementAttribute.class);
            }
        }
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        boolean hasMoreTokens = false;
        if (termAtt != null) {
            try {
                hasMoreTokens = buffer.incrementToken();
                while (hasMoreTokens) {
                    int positionIncrement;
                    ++numTokens;
                    int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        severalTokensAtSamePosition = true;
                    }
                    hasMoreTokens = buffer.incrementToken();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            buffer.reset();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (numTokens == 0) {
            return this.zeroTermsQuery();
        }
        if (type == Type.BOOLEAN) {
            if (numTokens == 1) {
                String term = null;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Query q = this.newTermQuery(mapper, fieldTerm.createTerm(term));
                return QueryParsers.wrapSmartNameQuery(q, smartNameFieldMappers, this.parseContext);
            }
            BooleanQuery q = new BooleanQuery(positionCount == 1);
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Query currentQuery = this.newTermQuery(mapper, fieldTerm.createTerm(term));
                q.add(currentQuery, this.occur);
            }
            return QueryParsers.wrapSmartNameQuery(q, smartNameFieldMappers, this.parseContext);
        }
        if (type == Type.PHRASE) {
            if (severalTokensAtSamePosition) {
                MultiPhraseQuery mpq = new MultiPhraseQuery();
                mpq.setSlop(this.phraseSlop);
                ArrayList<Term> multiTerms = new ArrayList<Term>();
                int position = -1;
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    int positionIncrement = 1;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                        if (posIncrAtt != null) {
                            positionIncrement = posIncrAtt.getPositionIncrement();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (positionIncrement > 0 && multiTerms.size() > 0) {
                        if (this.enablePositionIncrements) {
                            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                        } else {
                            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                        }
                        multiTerms.clear();
                    }
                    position += positionIncrement;
                    multiTerms.add(fieldTerm.createTerm(term));
                }
                if (this.enablePositionIncrements) {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                } else {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                }
                return QueryParsers.wrapSmartNameQuery(mpq, smartNameFieldMappers, this.parseContext);
            }
            PhraseQuery pq = new PhraseQuery();
            pq.setSlop(this.phraseSlop);
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this.enablePositionIncrements) {
                    pq.add(fieldTerm.createTerm(term), position += positionIncrement);
                    continue;
                }
                pq.add(fieldTerm.createTerm(term));
            }
            return QueryParsers.wrapSmartNameQuery(pq, smartNameFieldMappers, this.parseContext);
        }
        if (type == Type.PHRASE_PREFIX) {
            MultiPhrasePrefixQuery mpq = new MultiPhrasePrefixQuery();
            mpq.setSlop(this.phraseSlop);
            mpq.setMaxExpansions(this.maxExpansions);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    if (this.enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                    }
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(fieldTerm.createTerm(term));
            }
            if (this.enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
            }
            return QueryParsers.wrapSmartNameQuery(mpq, smartNameFieldMappers, this.parseContext);
        }
        throw new ElasticSearchIllegalStateException("No type found for [" + (Object)((Object)type) + "]");
    }

    private Query newTermQuery(@Nullable FieldMapper mapper, Term term) {
        Query termQuery;
        if (this.fuzziness != null) {
            Query query;
            if (mapper != null && (query = mapper.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions)) instanceof FuzzyQuery) {
                QueryParsers.setRewriteMethod((MultiTermQuery)((FuzzyQuery)query), this.fuzzyRewriteMethod);
            }
            query = new FuzzyQuery(term, Float.parseFloat(this.fuzziness), this.fuzzyPrefixLength, this.maxExpansions);
            QueryParsers.setRewriteMethod((MultiTermQuery)query, this.rewriteMethod);
            return query;
        }
        if (mapper != null && (termQuery = mapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return new TermQuery(term);
    }

    protected Query zeroTermsQuery() {
        return this.zeroTermsQuery == ZeroTermsQuery.NONE ? MatchNoDocsQuery.INSTANCE : Queries.MATCH_ALL_QUERY;
    }

    public static enum ZeroTermsQuery {
        NONE,
        ALL;

    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }
}

