/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class DocsStats
implements Streamable,
ToXContent {
    long count = 0L;
    long deleted = 0L;

    public DocsStats() {
    }

    public DocsStats(long count, long deleted) {
        this.count = count;
        this.deleted = deleted;
    }

    public void add(DocsStats docsStats) {
        if (docsStats == null) {
            return;
        }
        this.count += docsStats.count;
        this.deleted += docsStats.deleted;
    }

    public long count() {
        return this.count;
    }

    public long getCount() {
        return this.count;
    }

    public long deleted() {
        return this.deleted;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public static DocsStats readDocStats(StreamInput in) throws IOException {
        DocsStats docsStats = new DocsStats();
        docsStats.readFrom(in);
        return docsStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.deleted = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.deleted);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.DOCS);
        builder.field(Fields.COUNT, this.count);
        builder.field(Fields.DELETED, this.deleted);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString DOCS = new XContentBuilderString("docs");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString DELETED = new XContentBuilderString("deleted");

        Fields() {
        }
    }
}

