/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jsonschema;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import io.hawt.jsonschema.SchemaLookupMXBean;
import io.hawt.jsonschema.internal.BeanValidationAnnotationModule;
import io.hawt.jsonschema.internal.IgnorePropertiesBackedByTransientFields;
import io.hawt.util.MBeanSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLookup
extends MBeanSupport
implements SchemaLookupMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(SchemaLookup.class);
    private static SchemaLookup singleton;
    private ObjectMapper mapper;

    public static SchemaLookup getSingleton() {
        if (singleton == null) {
            new SchemaLookup().init();
        }
        return singleton;
    }

    public void init() {
        LOG.debug("Creating hawtio SchemaLookup instance");
        try {
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
                this.mapper.setVisibilityChecker((VisibilityChecker)new IgnorePropertiesBackedByTransientFields(this.mapper.getVisibilityChecker()));
                JaxbAnnotationModule module1 = new JaxbAnnotationModule();
                this.mapper.registerModule((Module)module1);
                BeanValidationAnnotationModule module2 = new BeanValidationAnnotationModule();
                this.mapper.registerModule((Module)module2);
            }
            super.init();
            singleton = this;
        }
        catch (Exception e) {
            LOG.warn("Exception during initialization: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String getDefaultObjectName() {
        return "hawtio:type=SchemaLookup";
    }

    protected Class<?> getClass(String name) {
        BundleContext bundleContext = null;
        Bundle currentBundle = FrameworkUtil.getBundle(this.getClass());
        if (currentBundle != null) {
            bundleContext = currentBundle.getBundleContext();
        }
        if (bundleContext != null) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = bundleContext.getBundles()) {
                if (bundle.getState() < 4) continue;
                try {
                    return bundle.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        } else {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to find class for {}", (Object)name);
                throw new RuntimeException(e);
            }
        }
        LOG.warn("Failed to find class for {}", (Object)name);
        throw new RuntimeException(new ClassNotFoundException(name));
    }

    @Override
    public String getSchemaForClass(String name) {
        Class<?> clazz = this.getClass(name);
        return this.getSchemaForClass(clazz);
    }

    public String getSchemaForClass(Class<?> clazz) {
        LOG.info("Looking up schema for " + clazz.getCanonicalName());
        String name = clazz.getName();
        try {
            ObjectWriter writer = this.mapper.writer().withDefaultPrettyPrinter();
            return writer.writeValueAsString((Object)this.mapper.generateJsonSchema(clazz));
        }
        catch (Exception e) {
            LOG.warn("Failed to generate JSON schema for class {}", (Object)name, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

