/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaas;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.config.JaasRealm;
import org.osgi.framework.BundleContext;

@ThreadSafe
@Component(name="io.fabric8.jaas", label="%Fabric8 Jaas Realm", policy=ConfigurationPolicy.OPTIONAL, immediate=false, metatype=true)
@Service(value={JaasRealm.class})
@Properties(value={@Property(name="supports.container.tokens", value={"true"}, propertyPrivate=true)})
public final class FabricJaasRealm
extends AbstractComponent
implements JaasRealm {
    private static final String REALM = "karaf";
    private static final String ZK_LOGIN_MODULE = "io.fabric8.jaas.ZookeeperLoginModule";
    private static final String PATH = "path";
    private static final String ENCRYPTION_NAME = "encryption.name";
    private static final String ENCRYPTION_ENABLED = "encryption.enabled";
    private static final String ENCRYPTION_PREFIX = "encryption.prefix";
    private static final String ENCRYPTION_SUFFIX = "encryption.suffix";
    private static final String ENCRYPTION_ALGORITHM = "encryption.algorithm";
    private static final String ENCRYPTION_ENCODING = "encryption.encoding";
    private static final String MODULE = "org.apache.karaf.jaas.module";
    @Property(name="org.apache.karaf.jaas.module", label="Login Module Class", value={"io.fabric8.jaas.ZookeeperLoginModule"})
    private String module;
    @Property(name="encryption.name", label="Encryption Service Name", description="The encryption service name. Defaults to basic, a more powerful alternative is jasypt", value={"basic"})
    private String encryptionName;
    @Property(name="encryption.enabled", label="Encryption Enabled", description="Flag that enables encryption", boolValue={true})
    private Boolean encryptionEnabled;
    @Property(name="encryption.prefix", label="Encryption Prefix", description="The encrypted password will be prefixed with that value", value={"{CRYPT}"})
    private String encryptionPrefix;
    @Property(name="encryption.suffix", label="Encryption Suffix", description="The encrypted password will be suffixed with that value", value={"{CRYPT}"})
    private String encryptionSuffix;
    @Property(name="encryption.algorithm", label="Encryption Algorithm", description="The encryption algorithm to use on password", value={"MD5"})
    private String encryptionAlgorithm;
    @Property(name="encryption.encoding", label="Encryption Encoding", description="The encryption encoding to use on password", value={"hexadecimal"})
    private String encryptionEncoding;
    @Property(name="path", label="Users Path", description="The path property to pass to the login module", value={"/fabric/authentication/users"})
    private String path;
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private final List<AppConfigurationEntry> enties = new ArrayList<AppConfigurationEntry>();

    @Activate
    void activate(BundleContext bundleContext, Map<String, Object> configuration) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.putAll(configuration);
        options.put(BundleContext.class.getName(), bundleContext);
        options.put(MODULE, ZK_LOGIN_MODULE);
        options.put("org.apache.karaf.jaas.bundle", Long.toString(bundleContext.getBundle().getBundleId()));
        this.enties.add(new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options));
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getName() {
        this.assertValid();
        return REALM;
    }

    public int getRank() {
        this.assertValid();
        return 1;
    }

    public AppConfigurationEntry[] getEntries() {
        this.assertValid();
        return this.enties.toArray(new AppConfigurationEntry[this.enties.size()]);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

