/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.aries.jmx.JMXThreadFactory;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.MBeanServiceTracker;
import org.apache.aries.jmx.agent.JMXAgent;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.apache.aries.jmx.cm.ConfigurationAdminMBeanHandler;
import org.apache.aries.jmx.framework.BundleStateMBeanHandler;
import org.apache.aries.jmx.framework.FrameworkMBeanHandler;
import org.apache.aries.jmx.framework.PackageStateMBeanHandler;
import org.apache.aries.jmx.framework.ServiceStateMBeanHandler;
import org.apache.aries.jmx.framework.wiring.BundleWiringStateMBeanHandler;
import org.apache.aries.jmx.permissionadmin.PermissionAdminMBeanHandler;
import org.apache.aries.jmx.provisioning.ProvisioningServiceMBeanHandler;
import org.apache.aries.jmx.useradmin.UserAdminMBeanHandler;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class JMXAgentImpl
implements JMXAgent {
    private ServiceTracker mbeanServiceTracker;
    private Map<MBeanHandler, Boolean> mbeansHandlers;
    private JMXAgentContext agentContext;
    private Logger logger;
    private ExecutorService registrationExecutor;

    public JMXAgentImpl(Logger logger) {
        this.logger = logger;
        this.mbeansHandlers = new HashMap<MBeanHandler, Boolean>();
        this.registrationExecutor = Executors.newSingleThreadExecutor(new JMXThreadFactory("JMX OSGi Agent"));
    }

    public synchronized void start() {
        this.logger.log(3, "Starting JMX OSGi agent");
        BundleContext bc = this.agentContext.getBundleContext();
        FrameworkMBeanHandler frameworkHandler = new FrameworkMBeanHandler(bc, this.logger);
        this.mbeansHandlers.put(frameworkHandler, Boolean.FALSE);
        frameworkHandler.open();
        BundleStateMBeanHandler bundleStateHandler = new BundleStateMBeanHandler(bc, this.logger);
        this.mbeansHandlers.put(bundleStateHandler, Boolean.FALSE);
        bundleStateHandler.open();
        BundleWiringStateMBeanHandler revisionsStateHandler = new BundleWiringStateMBeanHandler(bc, this.logger);
        this.mbeansHandlers.put(revisionsStateHandler, Boolean.FALSE);
        revisionsStateHandler.open();
        ServiceStateMBeanHandler serviceStateHandler = new ServiceStateMBeanHandler(bc, this.logger);
        this.mbeansHandlers.put(serviceStateHandler, Boolean.FALSE);
        serviceStateHandler.open();
        PackageStateMBeanHandler packageStateHandler = new PackageStateMBeanHandler(bc, this.logger);
        this.mbeansHandlers.put(packageStateHandler, Boolean.FALSE);
        packageStateHandler.open();
        PermissionAdminMBeanHandler permissionAdminHandler = new PermissionAdminMBeanHandler(this.agentContext);
        this.mbeansHandlers.put(permissionAdminHandler, Boolean.FALSE);
        permissionAdminHandler.open();
        UserAdminMBeanHandler userAdminHandler = new UserAdminMBeanHandler(this.agentContext);
        this.mbeansHandlers.put(userAdminHandler, Boolean.FALSE);
        userAdminHandler.open();
        ConfigurationAdminMBeanHandler configAdminHandler = new ConfigurationAdminMBeanHandler(this.agentContext);
        this.mbeansHandlers.put(configAdminHandler, Boolean.FALSE);
        configAdminHandler.open();
        ProvisioningServiceMBeanHandler provServiceHandler = new ProvisioningServiceMBeanHandler(this.agentContext);
        this.mbeansHandlers.put(provServiceHandler, Boolean.FALSE);
        provServiceHandler.open();
        this.mbeanServiceTracker = new MBeanServiceTracker(this.agentContext);
        this.mbeanServiceTracker.open();
    }

    public synchronized void registerMBeans(MBeanServer server) {
        for (MBeanHandler mbeanHandler : this.mbeansHandlers.keySet()) {
            if (this.mbeansHandlers.get(mbeanHandler) != Boolean.FALSE) continue;
            String name = mbeanHandler.getName();
            StandardMBean mbean = mbeanHandler.getMbean();
            if (mbean == null) continue;
            try {
                this.logger.log(3, "Registering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.registerMBean(mbean, new ObjectName(name));
                this.mbeansHandlers.put(mbeanHandler, Boolean.TRUE);
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.log(1, "MBean is already registered", e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.log(1, "MBean is not compliant MBean", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname", e);
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null", e);
            }
        }
    }

    public synchronized void unregisterMBeans(MBeanServer server) {
        for (MBeanHandler mBeanHandler : this.mbeansHandlers.keySet()) {
            if (this.mbeansHandlers.get(mBeanHandler) != Boolean.TRUE) continue;
            try {
                String name = mBeanHandler.getName();
                StandardMBean mbean = mBeanHandler.getMbean();
                if (mbean == null) continue;
                this.logger.log(3, "Unregistering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.unregisterMBean(new ObjectName(name));
                this.mbeansHandlers.put(mBeanHandler, Boolean.FALSE);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't unregister MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "MBean doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to unregister with no valid objectname", e);
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null ", e);
            }
            catch (Exception e) {
                this.logger.log(1, "Cannot unregister MBean: " + mBeanHandler, e);
            }
        }
    }

    public synchronized void registerMBean(MBeanHandler mBeanHandler) {
        Object[] servers;
        for (Object server : servers = this.getMBeanServers()) {
            String name = mBeanHandler.getName();
            StandardMBean mbean = mBeanHandler.getMbean();
            try {
                this.logger.log(3, "Registering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                ((MBeanServer)server).registerMBean(mbean, new ObjectName(name));
                this.mbeansHandlers.put(mBeanHandler, Boolean.TRUE);
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.log(1, "MBean is already registered", e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.log(1, "MBean is not compliant MBean, Stopping registration", e);
                return;
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
    }

    public synchronized void unregisterMBean(MBeanHandler mBeanHandler) {
        Object[] servers;
        for (Object server : servers = this.getMBeanServers()) {
            String name = mBeanHandler.getName();
            try {
                this.logger.log(3, "Unregistering mbean  to MBeanServer " + server + " with name " + name);
                ((MBeanServer)server).unregisterMBean(new ObjectName(name));
                this.mbeansHandlers.put(mBeanHandler, Boolean.FALSE);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "MBean doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
    }

    public synchronized void unregisterMBean(String name) {
        Object[] servers;
        for (Object server : servers = this.getMBeanServers()) {
            try {
                this.logger.log(3, "Unregistering mbean  to MBeanServer " + server + " with name " + name);
                ((MBeanServer)server).unregisterMBean(new ObjectName(name));
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "MBean doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.logger.log(3, "Stopping JMX OSGi agent");
        JMXAgentImpl jMXAgentImpl = this;
        synchronized (jMXAgentImpl) {
            this.mbeanServiceTracker.close();
            for (MBeanHandler mBeanHandler : this.mbeansHandlers.keySet()) {
                mBeanHandler.close();
            }
        }
        if (this.registrationExecutor != null && !this.registrationExecutor.isShutdown()) {
            this.registrationExecutor.shutdown();
            try {
                this.registrationExecutor.awaitTermination(300L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.log(2, "Interrupted while waiting for executor shutdown", e);
            }
        }
    }

    public JMXAgentContext getAgentContext() {
        return this.agentContext;
    }

    public void setAgentContext(JMXAgentContext agentContext) {
        this.agentContext = agentContext;
    }

    private Object[] getMBeanServers() {
        Object[] servers = this.mbeanServiceTracker.getServices();
        return servers != null ? servers : new Object[]{};
    }

    public ExecutorService getRegistrationExecutor() {
        return this.registrationExecutor;
    }
}

