/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        if (!"ssh-connection".equals(this.service)) {
            throw new SshException(2, "Unsupported service '" + this.service + "'");
        }
        if (init) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_INFO_REQUEST, 0);
            buffer.putString("Password authentication");
            buffer.putString("");
            buffer.putString("en-US");
            buffer.putInt(1L);
            buffer.putString("Password: ");
            buffer.putBoolean(false);
            this.session.writePacket(buffer);
            return null;
        }
        SshConstants.Message cmd = buffer.getCommand();
        if (cmd != SshConstants.Message.SSH_MSG_USERAUTH_INFO_RESPONSE) {
            throw new SshException("Received unexepected message: " + (Object)((Object)cmd));
        }
        int num = buffer.getInt();
        if (num != 1) {
            throw new SshException("Expected 1 response from user but received " + num);
        }
        String password = buffer.getString();
        return this.checkPassword(this.session, this.username, password);
    }

    private boolean checkPassword(ServerSession session, String username, String password) throws Exception {
        PasswordAuthenticator auth = session.getServerFactoryManager().getPasswordAuthenticator();
        if (auth != null) {
            return auth.authenticate(username, password, session);
        }
        throw new Exception("No PasswordAuthenticator configured");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "keyboard-interactive";
        }

        @Override
        public UserAuth create() {
            return new UserAuthKeyboardInteractive();
        }
    }
}

