/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@ThreadSafe
@Component(name="io.fabric8.runtime.properties", label="Fabric8 Runtime Properties Service", immediate=true, metatype=false)
@Service(value={RuntimeProperties.class})
public class RuntimePropertiesService
extends AbstractComponent
implements RuntimeProperties {
    public static final String COMPONENT_NAME = "io.fabric8.runtime.properties";
    static final String ENV_PREFIX = "env.prefix";
    static final String DEFAULT_ENV_PREFIX = "FABRIC8_";
    static final String REPLACE_PATTERN = "-|\\.";
    private final Map<String, String> runtimeProperties = new ConcurrentHashMap<String, String>();
    @Property(name="env.prefix", label="Environment Variable Prefix", value={"FABRIC8_"})
    private String envPrefix = "FABRIC8_";
    private ComponentContext componentContext;

    @Activate
    void activate(ComponentContext componentContext) throws Exception {
        this.componentContext = componentContext;
        this.envPrefix = (String)componentContext.getProperties().get(ENV_PREFIX);
        this.assertPropertyNotNull("karaf.home");
        this.assertPropertyNotNull("karaf.base");
        this.assertPropertyNotNull("karaf.name");
        this.assertPropertyNotNull("karaf.data");
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getProperty(String key) {
        this.assertValid();
        return this.getPropertyInternal(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        this.assertValid();
        return this.getPropertyInternal(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.assertValid();
        this.setPropertyInternal(key, value);
    }

    private String getPropertyInternal(String key, String defaultValue) {
        String result = this.runtimeProperties.get(key);
        if (result == null) {
            BundleContext syscontext = this.componentContext.getBundleContext();
            result = syscontext.getProperty(key);
        }
        if (result == null) {
            result = System.getenv(RuntimePropertiesService.toEnvVariable(this.envPrefix, key));
        }
        return result != null ? result : defaultValue;
    }

    private void setPropertyInternal(String key, String value) {
        if (value != null) {
            this.runtimeProperties.put(key, value);
        }
    }

    public void putProperties(Map<String, String> properties) {
        this.runtimeProperties.putAll(properties);
    }

    private void assertPropertyNotNull(String propName) {
        if (this.getPropertyInternal(propName, null) == null) {
            throw new IllegalStateException("Cannot obtain required property: " + propName);
        }
    }

    static String toEnvVariable(String prefix, String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return prefix + name.replaceAll(REPLACE_PATTERN, "_").toUpperCase();
    }
}

