/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.Watching;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class ExistsBuilderImpl
implements ExistsBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Watching watching;

    ExistsBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.watching = new Watching();
    }

    @Override
    public BackgroundPathable<Stat> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("ExistsBuilderImpl-Background");
        AsyncCallback.StatCallback callback = new AsyncCallback.StatCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, Stat stat) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(ExistsBuilderImpl.this.client, CuratorEventType.EXISTS, rc, path, null, ctx, stat, null, null, null, null);
                ExistsBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().exists(operationAndData.getData(), true, callback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().exists(operationAndData.getData(), this.watching.getWatcher(), callback, this.backgrounding.getContext());
        }
    }

    @Override
    public Stat forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        Stat returnStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
        } else {
            returnStat = this.pathInForeground(path);
        }
        return returnStat;
    }

    private Stat pathInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("ExistsBuilderImpl-Foreground");
        Stat returnStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                Stat returnStat = ExistsBuilderImpl.this.watching.isWatched() ? ExistsBuilderImpl.this.client.getZooKeeper().exists(path, true) : ExistsBuilderImpl.this.client.getZooKeeper().exists(path, ExistsBuilderImpl.this.watching.getWatcher());
                return returnStat;
            }
        });
        trace.commit();
        return returnStat;
    }
}

