/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleSelector {
    private final CommandSession session;
    private final BundleContext bundleContext;

    public BundleSelector(BundleContext bundleContext, CommandSession session) {
        this.bundleContext = bundleContext;
        this.session = session;
    }

    public List<Bundle> selectBundles(List<String> ids, boolean force) throws Exception {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (ids != null && !ids.isEmpty()) {
            for (String id : ids) {
                if (id == null) continue;
                Pattern pattern = Pattern.compile("^\\d+$");
                Matcher matcher = pattern.matcher(id);
                if (matcher.find()) {
                    Bundle bundle = this.getBundleById(id);
                    this.addBundle(bundle, id, force, bundles);
                    continue;
                }
                pattern = Pattern.compile("^(\\d+)-(\\d+)$");
                matcher = pattern.matcher(id);
                if (matcher.find()) {
                    long endId;
                    int index = id.indexOf(45);
                    long startId = Long.parseLong(id.substring(0, index));
                    if (startId >= (endId = Long.parseLong(id.substring(index + 1)))) continue;
                    for (long i = startId; i <= endId; ++i) {
                        Bundle bundle = this.bundleContext.getBundle(i);
                        this.addBundle(bundle, String.valueOf(i), force, bundles);
                    }
                    continue;
                }
                int index = id.indexOf(47);
                List<Bundle> bundlesByName = null;
                bundlesByName = index != -1 ? this.getBundleByNameAndVersion(id.substring(0, index), id.substring(index + 1)) : this.getBundleByName(id);
                for (Bundle bundleByName : bundlesByName) {
                    this.addBundle(bundleByName, id, force, bundles);
                }
            }
        }
        return bundles;
    }

    public Bundle getBundle(String id, boolean force) throws Exception {
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(id);
        List<Bundle> bundles = this.selectBundles(ids, force);
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles.get(0);
    }

    private void addBundle(Bundle bundle, String id, boolean force, List<Bundle> bundles) throws Exception {
        if (bundle == null) {
            System.err.println("Bundle " + id + " is invalid");
        } else if (force || !Util.isASystemBundle(this.bundleContext, bundle) || Util.accessToSystemBundleIsAllowed(bundle.getBundleId(), this.session)) {
            bundles.add(bundle);
        }
    }

    private Bundle getBundleById(String id) {
        Bundle bundle = null;
        try {
            long idNumber = Long.parseLong(id);
            bundle = this.bundleContext.getBundle(idNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bundle;
    }

    private List<Bundle> getBundleByName(String name) {
        return this.getBundleByNameAndVersion(name, null);
    }

    private List<Bundle> getBundleByNameAndVersion(String name, String version) {
        Bundle[] bundles = this.bundleContext.getBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        Pattern namePattern = Pattern.compile(name);
        for (int i = 0; i < bundles.length; ++i) {
            boolean nameMatch;
            String bundleSymbolicName = bundles[i].getSymbolicName();
            if (bundleSymbolicName == null) continue;
            Matcher symbolicNameMatcher = namePattern.matcher(bundleSymbolicName);
            Matcher nameMatcher = null;
            String bundleName = (String)bundles[i].getHeaders().get("Bundle-Name");
            if (bundleName != null) {
                nameMatcher = namePattern.matcher(bundleName);
            }
            if (version != null) {
                Pattern versionPattern;
                Matcher versionMatcher;
                boolean nameMatch2;
                String bundleVersion = (String)bundles[i].getHeaders().get("Bundle-Version");
                if (bundleVersion == null) continue;
                boolean bl = nameMatch2 = nameMatcher != null && nameMatcher.find() || symbolicNameMatcher.find();
                if (!nameMatch2 || !(versionMatcher = (versionPattern = Pattern.compile(version)).matcher(bundleVersion)).find()) continue;
                result.add(bundles[i]);
                continue;
            }
            boolean bl = nameMatch = nameMatcher != null && nameMatcher.find() || symbolicNameMatcher.find();
            if (!nameMatch) continue;
            result.add(bundles[i]);
        }
        return result;
    }
}

