/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.groups.internal;

import io.fabric8.groups.Group;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.DelegateZooKeeperGroup;
import io.fabric8.groups.internal.ManagedGroupFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiManagedGroupFactory
implements ManagedGroupFactory {
    private final ManagedGroupFactory delegate;

    public OsgiManagedGroupFactory(ClassLoader loader) {
        this.delegate = new OsgiTrackingManagedGroupFactory(loader);
    }

    @Override
    public CuratorFramework getCurator() {
        return this.delegate.getCurator();
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
        return this.delegate.createGroup(path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    static class OsgiTrackingManagedGroupFactory
    implements ManagedGroupFactory,
    ServiceTrackerCustomizer<CuratorFramework, CuratorFramework> {
        private final BundleContext bundleContext;
        private final ServiceTracker<CuratorFramework, CuratorFramework> tracker;
        private CuratorFramework curator;
        private final List<DelegateZooKeeperGroup<?>> groups = new ArrayList();

        OsgiTrackingManagedGroupFactory(ClassLoader loader) {
            this(OsgiTrackingManagedGroupFactory.getBundleContext(loader));
        }

        static BundleContext getBundleContext(ClassLoader loader) {
            if (!(loader instanceof BundleReference)) {
                throw new IllegalStateException("Not an OSGi ClassLoader");
            }
            return ((BundleReference)loader).getBundle().getBundleContext();
        }

        OsgiTrackingManagedGroupFactory(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.tracker = new ServiceTracker(bundleContext, CuratorFramework.class, (ServiceTrackerCustomizer)this);
            this.tracker.open();
        }

        public CuratorFramework addingService(ServiceReference<CuratorFramework> reference) {
            CuratorFramework curator = (CuratorFramework)this.bundleContext.getService(reference);
            this.useCurator(curator);
            return curator;
        }

        public void modifiedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
        }

        public void removedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
            this.useCurator(null);
            this.bundleContext.ungetService(reference);
        }

        protected void useCurator(CuratorFramework curator) {
            this.curator = curator;
            for (DelegateZooKeeperGroup<?> group : this.groups) {
                group.useCurator(curator);
            }
        }

        @Override
        public CuratorFramework getCurator() {
            return this.curator;
        }

        @Override
        public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
            return new DelegateZooKeeperGroup<T>(path, clazz){

                @Override
                public void start() {
                    this.useCurator(OsgiTrackingManagedGroupFactory.this.curator);
                    OsgiTrackingManagedGroupFactory.this.groups.add(this);
                    super.start();
                }

                @Override
                public void close() throws IOException {
                    OsgiTrackingManagedGroupFactory.this.groups.remove(this);
                    super.close();
                }
            };
        }

        @Override
        public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
            throw new IllegalStateException("not supported");
        }

        @Override
        public void close() {
            this.tracker.close();
        }
    }
}

