/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.DynamicReference;
import io.fabric8.api.FabricException;
import io.fabric8.api.PlaceholderResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlaceholderResolverHelpers {
    public static final Pattern SCHEME_PATTERN = Pattern.compile("\\$\\{([^ :\\}]+):([^\\}]*\\})");

    private PlaceholderResolverHelpers() {
    }

    public static Set<String> getSchemeForValue(String value) {
        HashSet<String> schemes = new HashSet<String>();
        Matcher matcher = SCHEME_PATTERN.matcher(value);
        while (matcher.find()) {
            String scheme = matcher.group(1);
            schemes.add(scheme);
            String remaining = matcher.group(2);
            if (remaining == null) continue;
            schemes.addAll(PlaceholderResolverHelpers.getSchemeForValue(remaining));
        }
        return schemes;
    }

    public static Set<String> getSchemesForConfig(Map<String, String> props) {
        HashSet<String> schemes = new HashSet<String>();
        for (Map.Entry<String, String> e : props.entrySet()) {
            String value = e.getValue();
            schemes.addAll(PlaceholderResolverHelpers.getSchemeForValue(value));
        }
        return schemes;
    }

    public static Set<String> getSchemesForProfileConfigurations(Map<String, Map<String, String>> configs) {
        HashSet<String> schemes = new HashSet<String>();
        for (Map.Entry<String, Map<String, String>> e : configs.entrySet()) {
            Map<String, String> value = e.getValue();
            schemes.addAll(PlaceholderResolverHelpers.getSchemesForConfig(value));
        }
        return schemes;
    }

    public static Map<String, PlaceholderResolver> waitForPlaceHolderResolvers(ExecutorService executor, Set<String> schemes, Map<String, DynamicReference<PlaceholderResolver>> resolvers) {
        HashMap<String, PlaceholderResolver> result = new HashMap<String, PlaceholderResolver>();
        HashSet<String> notFound = new HashSet<String>(schemes);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        for (String scheme : schemes) {
            completionService.submit((Callable)resolvers.get(scheme));
        }
        try {
            for (int i = 0; i < schemes.size(); ++i) {
                try {
                    PlaceholderResolver resolver = (PlaceholderResolver)completionService.take().get();
                    if (resolver == null) continue;
                    result.put(resolver.getScheme(), resolver);
                    notFound.remove(resolver.getScheme());
                    continue;
                }
                catch (ExecutionException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            throw new FabricException("Error while waiting for placeholder resolvers.", (Throwable)ex);
        }
        if (!notFound.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Missing Placeholder Resolvers:");
            for (String resolver : notFound) {
                sb.append(" ").append(resolver);
            }
            throw new FabricException(sb.toString());
        }
        return result;
    }
}

