/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.BootstrapComplete;
import io.fabric8.api.Container;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.BundleUtils;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.bootstrap.DataStoreBootstrapTemplate;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.cluster.bootstrap", label="Fabric8 ZooKeeper Cluster Bootstrap", immediate=true, metatype=false)
@Service(value={ZooKeeperClusterBootstrap.class})
public final class ZooKeeperClusterBootstrapImpl
extends AbstractComponent
implements ZooKeeperClusterBootstrap {
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=DataStoreRegistrationHandler.class)
    private final ValidatingReference<DataStoreRegistrationHandler> registrationHandler = new ValidatingReference();
    @Reference(referenceInterface=BootstrapConfiguration.class)
    private final ValidatingReference<BootstrapConfiguration> bootstrapConfiguration = new ValidatingReference();
    @Property(name="name", label="Container Name", description="The name of the container", value={"${karaf.name}"})
    private String name;
    @Property(name="home", label="Container Home", description="The home directory of the container", value={"${karaf.home}"})
    private String home;
    @Property(name="data", label="Container Data", description="The data directory of the container", value={"${karaf.data}"})
    private String data;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext, Map<String, ?> configuration) throws Exception {
        this.bundleContext = bundleContext;
        this.configurer.configure(configuration, (Object)this);
        BootstrapConfiguration bootConfig = (BootstrapConfiguration)this.bootstrapConfiguration.get();
        CreateEnsembleOptions options = bootConfig.getBootstrapOptions();
        if (options.isEnsembleStart()) {
            this.startBundles(options);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void create(CreateEnsembleOptions options) {
        this.assertValid();
        try {
            ServiceLocator.awaitService((BundleContext)this.bundleContext, BootstrapComplete.class);
            this.stopBundles();
            DataStoreRegistrationHandler regHandler = (DataStoreRegistrationHandler)this.registrationHandler.get();
            BootstrapConfiguration bootConfig = (BootstrapConfiguration)this.bootstrapConfiguration.get();
            BundleContext syscontext = this.bundleContext.getBundle(0L).getBundleContext();
            if (options.isClean()) {
                bootConfig = this.cleanInternal(syscontext, bootConfig, regHandler);
            }
            BootstrapCreateHandler createHandler = new BootstrapCreateHandler(bootConfig, regHandler);
            createHandler.bootstrapFabric(this.name, this.home, options);
            this.startBundles(options);
            createHandler.waitForContainerAlive(this.name, syscontext, 30000L);
            if (options.isWaitForProvision() && options.isAgentEnabled()) {
                createHandler.waitForSuccessfulDeploymentOf(this.name, syscontext, options.getProvisionTimeout());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new FabricException("Unable to create zookeeper server configuration", (Throwable)ex);
        }
    }

    private BootstrapConfiguration cleanInternal(final BundleContext syscontext, BootstrapConfiguration bootConfig, DataStoreRegistrationHandler registrationHandler) throws TimeoutException {
        try {
            Configuration[] configs = ((ConfigurationAdmin)this.configAdmin.get()).listConfigurations("(|(service.factoryPid=io.fabric8.zookeeper.server)(service.pid=io.fabric8.zookeeper))");
            File karafData = new File(this.data);
            final CountDownLatch unregisterLatch = new CountDownLatch(1);
            Object listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 4) {
                        syscontext.removeServiceListener((ServiceListener)this);
                        unregisterLatch.countDown();
                    }
                }
            };
            syscontext.addServiceListener(listener, "(objectClass=" + BootstrapConfiguration.class.getName() + ")");
            ComponentContext componentContext = bootConfig.getComponentContext();
            componentContext.disableComponent("io.fabric8.zookeeper.configuration");
            if (!unregisterLatch.await(30L, TimeUnit.SECONDS)) {
                throw new TimeoutException("Timeout for unregistering BootstrapConfiguration service");
            }
            registrationHandler.removeRegistrationCallback();
            this.cleanConfigurations(configs);
            this.cleanZookeeperDirectory(karafData);
            this.cleanGitDirectory(karafData);
            final CountDownLatch registerLatch = new CountDownLatch(1);
            final AtomicReference sref = new AtomicReference();
            listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 1) {
                        syscontext.removeServiceListener((ServiceListener)this);
                        sref.set(event.getServiceReference());
                        registerLatch.countDown();
                    }
                }
            };
            syscontext.addServiceListener(listener, "(objectClass=" + BootstrapConfiguration.class.getName() + ")");
            componentContext.enableComponent("io.fabric8.zookeeper.configuration");
            if (!registerLatch.await(30L, TimeUnit.SECONDS)) {
                throw new TimeoutException("Timeout for registering BootstrapConfiguration service");
            }
            return (BootstrapConfiguration)syscontext.getService((ServiceReference)sref.get());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (TimeoutException toe) {
            throw toe;
        }
        catch (Exception ex) {
            throw new FabricException("Unable to delete zookeeper configuration", (Throwable)ex);
        }
    }

    private void cleanConfigurations(Configuration[] configs) throws IOException, InvalidSyntaxException {
        if (configs != null && configs.length > 0) {
            for (Configuration config : configs) {
                config.delete();
            }
        }
    }

    private void cleanZookeeperDirectory(File karafData) throws IOException {
        File zkdir = new File(karafData, "zookeeper");
        if (zkdir.isDirectory()) {
            File renamed = new File(karafData, "zookeeper." + System.currentTimeMillis());
            if (!zkdir.renameTo(renamed)) {
                throw new IOException("Cannot rename zookeeper data dir for removal: " + zkdir);
            }
            ZooKeeperClusterBootstrapImpl.delete(renamed);
        }
    }

    private void cleanGitDirectory(File karafData) throws IOException {
        File gitdir = new File(karafData, "git");
        if (gitdir.isDirectory()) {
            File renamed = new File(karafData, "git." + System.currentTimeMillis());
            if (!gitdir.renameTo(renamed)) {
                throw new IOException("Cannot rename git data dir for removal: " + gitdir);
            }
            ZooKeeperClusterBootstrapImpl.delete(renamed);
        }
    }

    private void stopBundles() throws BundleException {
        BundleUtils bundleUtils = new BundleUtils(this.bundleContext);
        bundleUtils.findAndStopBundle("io.fabric8.fabric-agent");
    }

    private void startBundles(CreateEnsembleOptions options) throws BundleException {
        BundleUtils bundleUtils = new BundleUtils(this.bundleContext);
        Bundle agentBundle = bundleUtils.findBundle("io.fabric8.fabric-agent");
        if (agentBundle != null && options.isAgentEnabled()) {
            agentBundle.start();
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterBootstrapImpl.delete(child);
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.bind((Object)service);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.unbind((Object)service);
    }

    void bindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.bind((Object)service);
    }

    void unbindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    static class BootstrapCreateHandler {
        private final BootstrapConfiguration bootConfig;
        private final DataStoreRegistrationHandler registrationHandler;

        BootstrapCreateHandler(BootstrapConfiguration bootConfig, DataStoreRegistrationHandler registrationHandler) {
            this.bootConfig = bootConfig;
            this.registrationHandler = registrationHandler;
        }

        void bootstrapFabric(String karafName, String karafHome, CreateEnsembleOptions options) throws IOException {
            String connectionUrl = this.bootConfig.getConnectionUrl(options);
            this.registrationHandler.setRegistrationCallback((DataStoreTemplate)new DataStoreBootstrapTemplate(karafName, karafHome, connectionUrl, options));
            this.bootConfig.createOrUpdateDataStoreConfig(options);
            this.bootConfig.createZooKeeeperServerConfig(options);
            this.bootConfig.createZooKeeeperClientConfig(connectionUrl, options);
        }

        private void waitForContainerAlive(String containerName, BundleContext syscontext, long timeout) throws TimeoutException {
            System.out.println(String.format("Waiting for container: %s", containerName));
            Exception lastException = null;
            long startedAt = System.currentTimeMillis();
            while (!Thread.interrupted() && System.currentTimeMillis() < startedAt + timeout) {
                ServiceReference sref = syscontext.getServiceReference(FabricService.class);
                FabricService fabricService = sref != null ? (FabricService)syscontext.getService(sref) : null;
                try {
                    Container container;
                    Container container2 = container = fabricService != null ? fabricService.getContainer(containerName) : null;
                    if (container != null && container.isAlive()) {
                        return;
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    lastException = ex;
                }
                catch (Exception ex) {
                    lastException = ex;
                }
            }
            TimeoutException toex = new TimeoutException("Cannot create container in time");
            if (lastException != null) {
                toex.initCause(lastException);
            }
            throw toex;
        }

        private void waitForSuccessfulDeploymentOf(String containerName, BundleContext syscontext, long timeout) throws TimeoutException {
            System.out.println(String.format("Waiting for container %s to provision.", containerName));
            Exception lastException = null;
            long startedAt = System.currentTimeMillis();
            while (!Thread.interrupted() && System.currentTimeMillis() < startedAt + timeout) {
                ServiceReference sref = syscontext.getServiceReference(FabricService.class);
                FabricService fabricService = sref != null ? (FabricService)syscontext.getService(sref) : null;
                try {
                    Container container;
                    Container container2 = container = fabricService != null ? fabricService.getContainer(containerName) : null;
                    if (container != null && container.isAlive() && "success".equals(container.getProvisionStatus())) {
                        return;
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    lastException = ex;
                }
                catch (Exception ex) {
                    lastException = ex;
                }
            }
            TimeoutException toex = new TimeoutException("Cannot provision container in time");
            if (lastException != null) {
                toex.initCause(lastException);
            }
            throw toex;
        }
    }
}

