/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.PatchService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.utils.Base64Encoder;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchServiceImpl
implements PatchService {
    private static final String PATCH_ID = "id";
    private static final String PATCH_DESCRIPTION = "description";
    private static final String PATCH_BUNDLES = "bundle";
    private static final String PATCH_COUNT = "count";
    private static final String PATCH_RANGE = "range";
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchServiceImpl.class);
    private final FabricService fabric;

    public PatchServiceImpl(FabricService fabric) {
        this.fabric = fabric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPatch(Version version, URL patch, String login, String password) {
        try {
            URI uploadUri = this.fabric.getMavenRepoUploadURI();
            ArrayList<PatchDescriptor> descriptors = new ArrayList<PatchDescriptor>();
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(patch.openStream()));
            try {
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    block23: {
                        if (!entry.isDirectory()) {
                            String entryName = entry.getName();
                            if (entryName.startsWith("repository/")) {
                                String fileName = entryName.substring("repository/".length());
                                while (fileName.startsWith("/")) {
                                    fileName = fileName.substring(1);
                                }
                                URL uploadUrl = uploadUri.resolve(fileName).toURL();
                                URLConnection con = uploadUrl.openConnection();
                                if (con instanceof HttpURLConnection) {
                                    ((HttpURLConnection)con).setRequestMethod("PUT");
                                }
                                if (login != null && password != null) {
                                    con.setRequestProperty("Authorization", "Basic " + Base64Encoder.encode(login + ":" + password));
                                }
                                con.setDoInput(true);
                                con.setDoOutput(true);
                                con.connect();
                                OutputStream os = con.getOutputStream();
                                try {
                                    try {
                                        int code;
                                        PatchServiceImpl.copy(zis, os);
                                        if (con instanceof HttpURLConnection && ((code = ((HttpURLConnection)con).getResponseCode()) < 200 || code >= 300)) {
                                            throw new IOException("Error uploading patched jars: " + ((HttpURLConnection)con).getResponseMessage());
                                        }
                                        break block23;
                                    }
                                    finally {
                                        zis.closeEntry();
                                    }
                                }
                                finally {
                                    PatchServiceImpl.close(os);
                                }
                            }
                            if (entryName.endsWith(".patch") && !entryName.contains("/")) {
                                try {
                                    Properties patchMetadata = new Properties();
                                    patchMetadata.load(zis);
                                    descriptors.add(new PatchDescriptor(patchMetadata));
                                }
                                finally {
                                    zis.closeEntry();
                                }
                            }
                        }
                    }
                    entry = zis.getNextEntry();
                }
            }
            finally {
                PatchServiceImpl.close(zis);
            }
            for (PatchDescriptor descriptor : descriptors) {
                String profileId = "patch-" + descriptor.getId();
                Profile profile = version.getProfile(profileId);
                if (profile != null) continue;
                profile = version.createProfile(profileId);
                profile.setOverrides(descriptor.getBundles());
                Profile defaultProfile = version.getProfile("default");
                ArrayList<Profile> parents = new ArrayList<Profile>(Arrays.asList(defaultProfile.getParents()));
                if (parents.contains(profile)) continue;
                parents.add(profile);
                defaultProfile.setParents(parents.toArray(new Profile[parents.size()]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to apply patch", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] b = new byte[4096];
            int l = is.read(b);
            while (l >= 0) {
                os.write(b, 0, l);
                l = is.read(b);
            }
        }
        finally {
            PatchServiceImpl.close(os);
        }
    }

    static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class PatchDescriptor {
        final String id;
        final String description;
        final List<String> bundles;

        PatchDescriptor(Properties properties) {
            this.id = properties.getProperty(PatchServiceImpl.PATCH_ID);
            this.description = properties.getProperty(PatchServiceImpl.PATCH_DESCRIPTION);
            this.bundles = new ArrayList<String>();
            int count = Integer.parseInt(properties.getProperty("bundle.count", "0"));
            for (int i = 0; i < count; ++i) {
                String url = properties.getProperty("bundle." + Integer.toString(i));
                String range = properties.getProperty("bundle." + Integer.toString(i) + "." + PatchServiceImpl.PATCH_RANGE);
                if (range != null) {
                    url = String.format("%s;range=%s", url, range);
                }
                this.bundles.add(url);
            }
        }

        PatchDescriptor(String id, String description, List<String> bundles) {
            this.id = id;
            this.description = description;
            this.bundles = bundles;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getBundles() {
            return this.bundles;
        }
    }
}

