/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.utils.DataStoreUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ProfileOverlayImpl
implements Profile {
    private final Profile self;
    private final boolean substitute;
    private final String environment;
    private final FabricService fabricService;

    public ProfileOverlayImpl(Profile self, String environment) {
        this(self, environment, false, null);
    }

    public ProfileOverlayImpl(Profile self, String environment, boolean substitute, FabricService fabricService) {
        this.self = self;
        this.substitute = substitute;
        this.environment = environment;
        this.fabricService = fabricService;
    }

    public String getId() {
        return this.self.getId();
    }

    public String getVersion() {
        return this.self.getVersion();
    }

    public Map<String, String> getAttributes() {
        return this.self.getAttributes();
    }

    public void setAttribute(String key, String value) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public Profile[] getParents() {
        return this.self.getParents();
    }

    public List<String> getLibraries() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.LIBRARIES);
    }

    public List<String> getEndorsedLibraries() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.ENDORSED);
    }

    public List<String> getExtensionLibraries() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.EXTENSION);
    }

    public List<String> getBundles() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.BUNDLES);
    }

    public List<String> getFabs() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.FABS);
    }

    public List<String> getFeatures() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.FEATURES);
    }

    public List<String> getRepositories() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.REPOSITORIES);
    }

    public List<String> getOverrides() {
        return ProfileImpl.getContainerConfigList(this, ProfileImpl.ConfigListType.OVERRIDES);
    }

    public Container[] getAssociatedContainers() {
        return this.self.getAssociatedContainers();
    }

    public Map<String, String> getContainerConfiguration() {
        Map<String, String> map = this.getConfigurations().get("io.fabric8.agent");
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public void setFileConfigurations(Map<String, byte[]> configurations) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setParents(Profile[] parents) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setConfiguration(String pid, Map<String, String> configuration) {
        Map<String, Map<String, String>> configurations = this.getConfigurations();
        configurations.put(pid, configuration);
        this.setConfigurations(configurations);
    }

    public void setBundles(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setFabs(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setFeatures(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setRepositories(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public void setOverrides(List<String> values) {
        throw new UnsupportedOperationException("Overlay profiles are read-only.");
    }

    public boolean configurationEquals(Profile other) {
        return this.self.configurationEquals(other);
    }

    public boolean agentConfigurationEquals(Profile other) {
        ProfileOverlayImpl otherOverlay = new ProfileOverlayImpl(other, this.environment);
        if (!this.getConfigurations().containsKey("io.fabric8.agent") && !otherOverlay.getConfigurations().containsKey("io.fabric8.agent")) {
            return true;
        }
        if (this.getConfigurations().containsKey("io.fabric8.agent") != otherOverlay.getConfigurations().containsKey("io.fabric8.agent")) {
            return false;
        }
        return !this.getConfigurations().containsKey("io.fabric8.agent") || this.getConfigurations().get("io.fabric8.agent").equals(otherOverlay.getConfigurations().get("io.fabric8.agent"));
    }

    public boolean exists() {
        return false;
    }

    public void refresh() {
        throw new UnsupportedOperationException("Can not refresh an overlay profile");
    }

    public void delete() {
        throw new UnsupportedOperationException("Can not delete an overlay profile");
    }

    public void delete(boolean force) {
        throw new UnsupportedOperationException("Can not delete an overlay profile");
    }

    public Profile getOverlay() {
        return this;
    }

    public Profile getOverlay(boolean substitute) {
        return new ProfileOverlayImpl(this.self, this.environment, substitute, this.fabricService);
    }

    public boolean isOverlay() {
        return true;
    }

    public int compareTo(Profile profile) {
        return this.self.compareTo((Object)profile);
    }

    private List<Profile> getInheritedProfiles() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        this.fillParentProfiles(this.self, profiles);
        return profiles;
    }

    private void fillParentProfiles(Profile profile, List<Profile> profiles) {
        for (Profile p : profile.getParents()) {
            this.fillParentProfiles(p, profiles);
        }
        if (!profiles.contains(profile)) {
            profiles.add(profile);
        }
    }

    private void supplement(Profile profile, Map<String, SupplementControl> aggregate) throws Exception {
        if (profile instanceof ProfileOverlayImpl && ((ProfileOverlayImpl)profile).self.equals(this.self)) {
            return;
        }
        Map configs = profile.getFileConfigurations();
        for (String key : configs.keySet()) {
            SupplementControl ctrl;
            String fileName;
            if (key.contains("#")) continue;
            byte[] value = (byte[])configs.get(key);
            if (this.environment != null && configs.containsKey(key + "#" + this.environment)) {
                value = (byte[])configs.get(key + "#" + this.environment);
            }
            if ((fileName = key).endsWith(".properties")) {
                ctrl = aggregate.get(fileName);
                if (ctrl != null) {
                    Properties childMap = DataStoreUtils.toProperties(value);
                    if (childMap.remove("#deleted#") != null) {
                        ctrl.props.clear();
                    }
                    for (Map.Entry<Object, Object> p : childMap.entrySet()) {
                        if ("#deleted#".equals(p.getValue())) {
                            ctrl.props.remove(p.getKey());
                            continue;
                        }
                        ctrl.props.put(p.getKey(), p.getValue());
                    }
                    continue;
                }
                ctrl = new SupplementControl();
                ctrl.props = DataStoreUtils.toProperties(value);
                aggregate.put(fileName, ctrl);
                continue;
            }
            ctrl = new SupplementControl();
            ctrl.data = value;
            aggregate.put(fileName, ctrl);
        }
    }

    public List<String> getConfigurationFileNames() {
        return Profiles.getConfigurationFileNames(this.getInheritedProfiles());
    }

    public byte[] getFileConfiguration(String fileName) {
        return Profiles.getFileConfiguration(this.getInheritedProfiles(), (String)fileName);
    }

    public Map<String, byte[]> getFileConfigurations() {
        try {
            HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
            for (Profile profile : this.getInheritedProfiles()) {
                this.supplement(profile, aggregate);
            }
            HashMap<String, byte[]> rc = new HashMap<String, byte[]>();
            for (Map.Entry entry : aggregate.entrySet()) {
                SupplementControl ctrl = (SupplementControl)entry.getValue();
                if (ctrl.props != null) {
                    ctrl.data = DataStoreUtils.toBytes(ctrl.props);
                }
                rc.put((String)entry.getKey(), ctrl.data);
            }
            return rc;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public Map<String, Map<String, String>> getConfigurations() {
        try {
            HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
            for (Profile profile : this.getInheritedProfiles()) {
                this.supplement(profile, aggregate);
            }
            HashMap<String, Map<String, String>> rc = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : aggregate.entrySet()) {
                SupplementControl ctrl = (SupplementControl)entry.getValue();
                if (ctrl.props == null) continue;
                rc.put(DataStoreUtils.stripSuffix((String)entry.getKey(), ".properties"), DataStoreUtils.toMap(ctrl.props));
            }
            if (this.substitute) {
                this.fabricService.substituteConfigurations(rc);
            }
            return rc;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public Map<String, String> getConfiguration(String pid) {
        return this.getConfigurations().get(pid);
    }

    public boolean isAbstract() {
        return this.self.isAbstract();
    }

    public boolean isLocked() {
        return this.self.isLocked();
    }

    public boolean isHidden() {
        return this.self.isHidden();
    }

    public String getProfileHash() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.self.getProfileHash());
        for (Profile parent : this.getParents()) {
            Profile parentOverlay = parent.getOverlay();
            sb.append("-").append(parentOverlay.getProfileHash());
        }
        return sb.toString();
    }

    private static class SupplementControl {
        byte[] data;
        Properties props;

        private SupplementControl() {
        }
    }
}

