/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.internal.ContainerImpl;
import io.fabric8.internal.GeoUtils;
import io.fabric8.utils.HostUtils;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.ZkDefs;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.registration.karaf", label="Fabric8 Karaf Container Registration", metatype=false)
@Service(value={ContainerRegistration.class, ConfigurationListener.class, ConnectionStateListener.class})
public final class KarafContainerRegistration
extends AbstractComponent
implements ContainerRegistration,
ConfigurationListener,
ConnectionStateListener {
    private transient Logger LOGGER = LoggerFactory.getLogger(KarafContainerRegistration.class);
    private static final String MANAGEMENT_PID = "org.apache.karaf.management";
    private static final String SSH_PID = "org.apache.karaf.shell";
    private static final String HTTP_PID = "org.ops4j.pax.web";
    private static final String JMX_SERVICE_URL = "serviceUrl";
    private static final String RMI_REGISTRY_BINDING_PORT_KEY = "rmiRegistryPort";
    private static final String RMI_SERVER_BINDING_PORT_KEY = "rmiServerPort";
    private static final String SSH_BINDING_PORT_KEY = "sshPort";
    private static final String HTTP_BINDING_PORT_KEY = "org.osgi.service.http.port";
    private static final String HTTPS_BINDING_PORT_KEY = "org.osgi.service.http.port.secure";
    private static final String RMI_REGISTRY_CONNECTION_PORT_KEY = "rmiRegistryConnectionPort";
    private static final String RMI_SERVER_CONNECTION_PORT_KEY = "rmiServerConnectionPort";
    private static final String SSH_CONNECTION_PORT_KEY = "sshConnectionPort";
    private static final String HTTP_CONNECTION_PORT_KEY = "org.osgi.service.http.connection.port";
    private static final String HTTPS_CONNECTION_PORT_KEY = "org.osgi.service.http.connection.port.secure";
    private static final String HTTP_ENABLED = "org.osgi.service.http.enabled";
    private static final String HTTPS_ENABLED = "org.osgi.service.http.secure.enabled";
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();

    @Activate
    void activate() {
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    private void activateInternal() {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String karafName = sysprops.getProperty("karaf.name");
        String version = sysprops.getProperty("fabric.version", "1.0");
        String profiles = sysprops.getProperty("fabric.profiles");
        try {
            if (profiles != null) {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(new String[]{karafName});
                String profileNode = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, karafName});
                ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionNode, (String)version);
                ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)profileNode, (String)profiles);
            }
            this.checkAlive();
            String domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(new String[]{karafName});
            Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
            if (stat != null) {
                ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
            }
            boolean openshiftEnv = Strings.notEmpty(System.getenv("OPENSHIFT_FUSE_DIR"));
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{karafName}), (String)sysprops.getProperty("bind.address", "0.0.0.0"));
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{karafName}), (String)this.getContainerResolutionPolicy(sysprops, (CuratorFramework)this.curator.get(), karafName));
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{karafName}), (String)HostUtils.getLocalHostName());
            if (openshiftEnv) {
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{karafName}), (String)System.getenv("OPENSHIFT_FUSE_IP"));
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{karafName}), (String)HostUtils.getLocalIp());
            } else {
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{karafName}), (String)HostUtils.getLocalIp());
            }
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{karafName}), (String)KarafContainerRegistration.getContainerPointer((CuratorFramework)this.curator.get(), karafName));
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_GEOLOCATION.getPath(new String[]{karafName}), (String)GeoUtils.getGeoLocation());
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                String address = sysprops.getProperty(resolver);
                if (address == null || address.isEmpty() || ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{karafName, resolver})) != null) continue;
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{karafName, resolver}), (String)address);
            }
            Container current = this.getContainer();
            sysprops.setProperty("java.rmi.server.hostname", current.getIp());
            this.registerJmx(current);
            this.registerSsh(current);
            this.registerHttp(current);
            String minimumPort = sysprops.getProperty("minimum.port");
            String maximumPort = sysprops.getProperty("maximum.port");
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{karafName}), (String)minimumPort);
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{karafName}), (String)maximumPort);
        }
        catch (Exception e) {
            this.LOGGER.warn("Error updating Fabric Container information. This exception will be ignored.", (Throwable)e);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    try {
                        this.checkAlive();
                        break;
                    }
                    catch (Exception ex) {
                        this.LOGGER.error("Error while checking/setting container status.");
                    }
                }
            }
        }
    }

    private void checkAlive() throws Exception {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String karafName = sysprops.getProperty("karaf.name");
        String nodeAlive = ZkPath.CONTAINER_ALIVE.getPath(new String[]{karafName});
        Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive);
        if (stat != null) {
            if (stat.getEphemeralOwner() != ((CuratorFramework)this.curator.get()).getZookeeperClient().getZooKeeper().getSessionId()) {
                ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive);
                ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive, (CreateMode)CreateMode.EPHEMERAL);
            }
        } else {
            ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive, (CreateMode)CreateMode.EPHEMERAL);
        }
    }

    private void registerJmx(Container container) throws Exception {
        int rmiRegistryPort = this.getRmiRegistryPort(container);
        int rmiRegistryConnectionPort = this.getRmiRegistryConnectionPort(container);
        int rmiServerPort = this.getRmiServerPort(container);
        int rmiServerConenctionPort = this.getRmiServerConnectionPort(container);
        String jmxUrl = this.getJmxUrl(container.getId(), rmiServerConenctionPort, rmiRegistryConnectionPort);
        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_JMX.getPath(new String[]{container.getId()}), (String)jmxUrl);
        ((FabricService)this.fabricService.get()).getPortService().registerPort(container, MANAGEMENT_PID, RMI_REGISTRY_BINDING_PORT_KEY, rmiRegistryPort);
        ((FabricService)this.fabricService.get()).getPortService().registerPort(container, MANAGEMENT_PID, RMI_SERVER_BINDING_PORT_KEY, rmiServerPort);
        Configuration configuration = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(MANAGEMENT_PID, null);
        this.updateIfNeeded(configuration, RMI_REGISTRY_BINDING_PORT_KEY, rmiRegistryPort);
        this.updateIfNeeded(configuration, RMI_SERVER_BINDING_PORT_KEY, rmiServerPort);
    }

    private int getRmiRegistryPort(Container container) throws IOException, KeeperException, InterruptedException {
        return this.getOrAllocatePortForKey(container, MANAGEMENT_PID, RMI_REGISTRY_BINDING_PORT_KEY, 1099);
    }

    private int getRmiRegistryConnectionPort(Container container, int defaultValue) throws IOException, KeeperException, InterruptedException {
        return this.getPortForKey(container, MANAGEMENT_PID, RMI_REGISTRY_CONNECTION_PORT_KEY, defaultValue);
    }

    private int getRmiRegistryConnectionPort(Container container) throws IOException, KeeperException, InterruptedException {
        return this.getRmiRegistryConnectionPort(container, this.getRmiRegistryPort(container));
    }

    private int getRmiServerPort(Container container) throws IOException, KeeperException, InterruptedException {
        return this.getOrAllocatePortForKey(container, MANAGEMENT_PID, RMI_SERVER_BINDING_PORT_KEY, 44444);
    }

    private int getRmiServerConnectionPort(Container container, int defaultValue) throws IOException, KeeperException, InterruptedException {
        return this.getPortForKey(container, MANAGEMENT_PID, RMI_SERVER_CONNECTION_PORT_KEY, defaultValue);
    }

    private int getRmiServerConnectionPort(Container container) throws IOException, KeeperException, InterruptedException {
        return this.getRmiServerConnectionPort(container, this.getRmiServerPort(container));
    }

    private String getJmxUrl(String name, int serverConnectionPort, int registryConnectionPort) throws IOException, KeeperException, InterruptedException {
        return "service:jmx:rmi://${zk:" + name + "/ip}:" + serverConnectionPort + "/jndi/rmi://${zk:" + name + "/ip}:" + registryConnectionPort + "/karaf-" + name;
    }

    private void registerSsh(Container container) throws Exception {
        int sshPort = this.getSshPort(container);
        int sshConnectionPort = this.getSshConnectionPort(container);
        String sshUrl = this.getSshUrl(container.getId(), sshConnectionPort);
        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_SSH.getPath(new String[]{container.getId()}), (String)sshUrl);
        ((FabricService)this.fabricService.get()).getPortService().registerPort(container, SSH_PID, SSH_BINDING_PORT_KEY, sshPort);
        Configuration configuration = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(SSH_PID, null);
        this.updateIfNeeded(configuration, SSH_BINDING_PORT_KEY, sshPort);
    }

    private int getSshPort(Container container) throws IOException, KeeperException, InterruptedException {
        return this.getOrAllocatePortForKey(container, SSH_PID, SSH_BINDING_PORT_KEY, 8101);
    }

    private int getSshConnectionPort(Container container) throws IOException, KeeperException, InterruptedException {
        return this.getSshConnectionPort(container, this.getSshPort(container));
    }

    private int getSshConnectionPort(Container container, int defaultValue) throws IOException, KeeperException, InterruptedException {
        return this.getPortForKey(container, SSH_PID, SSH_CONNECTION_PORT_KEY, defaultValue);
    }

    private String getSshUrl(String name, int sshPort) throws IOException, KeeperException, InterruptedException {
        return "${zk:" + name + "/ip}:" + sshPort;
    }

    private void registerHttp(Container container) throws Exception {
        boolean httpEnabled = this.isHttpEnabled();
        boolean httpsEnabled = this.isHttpsEnabled();
        String protocol = httpsEnabled && !httpEnabled ? "https" : "http";
        int httpPort = httpsEnabled && !httpEnabled ? this.getHttpsPort(container) : this.getHttpPort(container);
        int httpConnectionPort = httpsEnabled && !httpEnabled ? this.getHttpsConnectionPort(container) : this.getHttpConnectionPort(container);
        String httpUrl = this.getHttpUrl(protocol, container.getId(), httpConnectionPort);
        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_HTTP.getPath(new String[]{container.getId()}), (String)httpUrl);
        ((FabricService)this.fabricService.get()).getPortService().registerPort(container, HTTP_PID, HTTP_BINDING_PORT_KEY, httpPort);
        Configuration configuration = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(HTTP_PID, null);
        this.updateIfNeeded(configuration, HTTP_BINDING_PORT_KEY, httpPort);
    }

    private boolean isHttpEnabled() throws IOException {
        Configuration configuration = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(HTTP_PID, null);
        Dictionary properties = configuration.getProperties();
        if (properties != null && properties.get(HTTP_ENABLED) != null) {
            return Boolean.parseBoolean(String.valueOf(properties.get(HTTP_ENABLED)));
        }
        return true;
    }

    private boolean isHttpsEnabled() throws IOException {
        Configuration configuration = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(HTTP_PID, null);
        Dictionary properties = configuration.getProperties();
        if (properties != null && properties.get(HTTPS_ENABLED) != null) {
            return Boolean.parseBoolean(String.valueOf(properties.get(HTTPS_ENABLED)));
        }
        return false;
    }

    private int getHttpPort(Container container) throws KeeperException, InterruptedException, IOException {
        String portProperty = ((RuntimeProperties)this.runtimeProperties.get()).getProperty(HTTP_BINDING_PORT_KEY);
        int defaultPort = portProperty != null ? Integer.parseInt(portProperty) : 8181;
        return this.getOrAllocatePortForKey(container, HTTP_PID, HTTP_BINDING_PORT_KEY, defaultPort);
    }

    private int getHttpConnectionPort(Container container, int defaultValue) throws KeeperException, InterruptedException, IOException {
        return this.getPortForKey(container, HTTP_PID, HTTP_CONNECTION_PORT_KEY, defaultValue);
    }

    private int getHttpConnectionPort(Container container) throws KeeperException, InterruptedException, IOException {
        return this.getHttpConnectionPort(container, this.getHttpPort(container));
    }

    private String getHttpUrl(String protocol, String name, int httpConnectionPort) throws IOException, KeeperException, InterruptedException {
        return protocol + "://${zk:" + name + "/ip}:" + httpConnectionPort;
    }

    private int getHttpsPort(Container container) throws KeeperException, InterruptedException, IOException {
        String portProperty = ((RuntimeProperties)this.runtimeProperties.get()).getProperty(HTTPS_BINDING_PORT_KEY);
        int defaultPort = portProperty != null ? Integer.parseInt(portProperty) : 8443;
        return this.getOrAllocatePortForKey(container, HTTP_PID, HTTPS_BINDING_PORT_KEY, defaultPort);
    }

    private int getHttpsConnectionPort(Container container) throws KeeperException, InterruptedException, IOException {
        return this.getPortForKey(container, HTTP_PID, HTTPS_CONNECTION_PORT_KEY, this.getHttpsPort(container));
    }

    private int getOrAllocatePortForKey(Container container, String pid, String key, int defaultValue) throws IOException, KeeperException, InterruptedException {
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(pid, null);
        Set unavailable = ((FabricService)this.fabricService.get()).getPortService().findUsedPortByHost(container);
        int port = ((FabricService)this.fabricService.get()).getPortService().lookupPort(container, pid, key);
        if (port > 0) {
            return port;
        }
        if (config.getProperties() != null && config.getProperties().get(key) != null) {
            try {
                port = Integer.parseInt((String)config.getProperties().get(key));
            }
            catch (NumberFormatException ex) {
                port = defaultValue;
            }
        } else {
            port = defaultValue;
        }
        while (unavailable.contains(port)) {
            ++port;
        }
        return port;
    }

    private int getPortForKey(Container container, String pid, String key, int defaultValue) throws IOException {
        int port = defaultValue;
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(pid, null);
        if (config.getProperties() != null && config.getProperties().get(key) != null) {
            try {
                port = Integer.parseInt((String)config.getProperties().get(key));
            }
            catch (NumberFormatException ex) {
                port = defaultValue;
            }
        } else {
            port = defaultValue;
        }
        return port;
    }

    private void updateIfNeeded(Configuration configuration, String key, Object value) throws IOException {
        Dictionary dictionary;
        if (configuration != null && (dictionary = configuration.getProperties()) != null && !String.valueOf(value).equals(dictionary.get(key))) {
            dictionary.put(key, String.valueOf(value));
            configuration.setBundleLocation(null);
            configuration.update(dictionary);
        }
    }

    private String getGlobalResolutionPolicy(RuntimeProperties sysprops, CuratorFramework zooKeeper) throws Exception {
        String policy = "localhostname";
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) != null) {
            policy = ZooKeeperUtils.getStringData((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"}));
        } else if (sysprops.getProperty("global.resolver") != null && validResolverList.contains(sysprops.getProperty("global.resolver"))) {
            policy = sysprops.getProperty("global.resolver");
            ZooKeeperUtils.setData((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"}), (String)policy);
        }
        return policy;
    }

    private String getContainerResolutionPolicy(RuntimeProperties sysprops, CuratorFramework zooKeeper, String container) throws Exception {
        String policy = null;
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container})) != null) {
            policy = ZooKeeperUtils.getStringData((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container}));
        } else if (sysprops.getProperty("local.resolver") != null && validResolverList.contains(sysprops.getProperty("local.resolver"))) {
            policy = sysprops.getProperty("local.resolver");
        }
        if (policy == null) {
            policy = this.getGlobalResolutionPolicy(sysprops, zooKeeper);
        }
        if (policy != null && ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container})) == null) {
            ZooKeeperUtils.setData((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container}), (String)policy);
        }
        return policy;
    }

    private static String getContainerPointer(CuratorFramework curator, String container) throws Exception {
        String pointer = "${zk:%s/%s}";
        String resolver = "${zk:%s/resolver}";
        return String.format(pointer, container, String.format(resolver, container));
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (this.isValid()) {
            try {
                Configuration config;
                Container current = this.getContainer();
                RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
                String karafName = sysprops.getProperty("karaf.name");
                if (event.getPid().equals(SSH_PID) && event.getType() == 1) {
                    config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(SSH_PID, null);
                    int sshPort = Integer.parseInt((String)config.getProperties().get(SSH_BINDING_PORT_KEY));
                    int sshConnectionPort = this.getSshConnectionPort(current, sshPort);
                    String sshUrl = this.getSshUrl(karafName, sshConnectionPort);
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_SSH.getPath(new String[]{karafName}), (String)sshUrl);
                    if (((FabricService)this.fabricService.get()).getPortService().lookupPort(current, SSH_PID, SSH_BINDING_PORT_KEY) != sshPort) {
                        ((FabricService)this.fabricService.get()).getPortService().unregisterPort(current, SSH_PID);
                        ((FabricService)this.fabricService.get()).getPortService().registerPort(current, SSH_PID, SSH_BINDING_PORT_KEY, sshPort);
                    }
                }
                if (event.getPid().equals(HTTP_PID) && event.getType() == 1) {
                    config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(HTTP_PID, null);
                    boolean httpEnabled = this.isHttpEnabled();
                    boolean httpsEnabled = this.isHttpsEnabled();
                    String protocol = httpsEnabled && !httpEnabled ? "https" : "http";
                    int httpPort = httpsEnabled && !httpEnabled ? Integer.parseInt((String)config.getProperties().get(HTTPS_BINDING_PORT_KEY)) : Integer.parseInt((String)config.getProperties().get(HTTP_BINDING_PORT_KEY));
                    int httpConnectionPort = httpsEnabled && !httpEnabled ? this.getHttpsConnectionPort(current) : this.getHttpConnectionPort(current, httpPort);
                    String httpUrl = this.getHttpUrl(protocol, karafName, httpConnectionPort);
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_HTTP.getPath(new String[]{karafName}), (String)httpUrl);
                    if (((FabricService)this.fabricService.get()).getPortService().lookupPort(current, HTTP_PID, HTTP_BINDING_PORT_KEY) != httpPort) {
                        ((FabricService)this.fabricService.get()).getPortService().unregisterPort(current, HTTP_PID);
                        ((FabricService)this.fabricService.get()).getPortService().registerPort(current, HTTP_PID, HTTP_BINDING_PORT_KEY, httpPort);
                    }
                }
                if (event.getPid().equals(MANAGEMENT_PID) && event.getType() == 1) {
                    config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(MANAGEMENT_PID, null);
                    int rmiServerPort = Integer.parseInt((String)config.getProperties().get(RMI_SERVER_BINDING_PORT_KEY));
                    int rmiServerConnectionPort = this.getRmiServerConnectionPort(current, rmiServerPort);
                    int rmiRegistryPort = Integer.parseInt((String)config.getProperties().get(RMI_REGISTRY_BINDING_PORT_KEY));
                    int rmiRegistryConnectionPort = this.getRmiRegistryConnectionPort(current, rmiRegistryPort);
                    String jmxUrl = this.getJmxUrl(karafName, rmiServerConnectionPort, rmiRegistryConnectionPort);
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_JMX.getPath(new String[]{karafName}), (String)jmxUrl);
                    sysprops.setProperty("java.rmi.server.hostname", current.getIp());
                    if (((FabricService)this.fabricService.get()).getPortService().lookupPort(current, MANAGEMENT_PID, RMI_REGISTRY_BINDING_PORT_KEY) != rmiRegistryPort || ((FabricService)this.fabricService.get()).getPortService().lookupPort(current, MANAGEMENT_PID, RMI_SERVER_BINDING_PORT_KEY) != rmiServerPort) {
                        ((FabricService)this.fabricService.get()).getPortService().unregisterPort(current, MANAGEMENT_PID);
                        ((FabricService)this.fabricService.get()).getPortService().registerPort(current, MANAGEMENT_PID, RMI_SERVER_BINDING_PORT_KEY, rmiServerPort);
                        ((FabricService)this.fabricService.get()).getPortService().registerPort(current, MANAGEMENT_PID, RMI_REGISTRY_BINDING_PORT_KEY, rmiRegistryPort);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Container getContainer() {
        try {
            return ((FabricService)this.fabricService.get()).getCurrentContainer();
        }
        catch (Exception e) {
            RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
            final String karafName = sysprops.getProperty("karaf.name");
            return new ContainerImpl(null, karafName, null){

                @Override
                public String getIp() {
                    try {
                        return ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)KarafContainerRegistration.this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{karafName}));
                    }
                    catch (Exception e) {
                        throw FabricException.launderThrowable((Throwable)e);
                    }
                }
            };
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }
}

