/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.ContainerOptions;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.HostUtils;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.utils.Ports;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.bootstrap.DataStoreBootstrapTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.configuration", label="Fabric8 Bootstrap Configuration", immediate=true, metatype=false)
@Service(value={BootstrapConfiguration.class})
public class BootstrapConfiguration
extends AbstractComponent {
    static final Logger LOGGER = LoggerFactory.getLogger(BootstrapConfiguration.class);
    public static final String ENSEMBLE_MARKER = "ensemble-created.properties";
    public static final String COMPONENT_NAME = "io.fabric8.zookeeper.configuration";
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=DataStoreRegistrationHandler.class)
    private final ValidatingReference<DataStoreRegistrationHandler> registrationHandler = new ValidatingReference();
    private CreateEnsembleOptions options;
    @Property(name="ensemble.auto.start", label="Ensemble Auto Start", description="Flag to automatically start a zookeeper ensemble", value={"${ensemble.auto.start}"})
    private boolean ensembleAutoStart;
    @Property(name="agent.auto.start", label="Agent Auto Start", description="Flag to automatically start the provisioning agent", value={"${agent.auto.start}"})
    private boolean agentAutoStart = true;
    @Property(name="bind.address", label="Bind Address", description="The Bind Address", value={"${bind.address}"})
    private String bindAddress = "0.0.0.0";
    @Property(name="zookeeper.password", label="ZooKeeper Password", description="The zookeeper password", value={"${zookeeper.password}"})
    private String zookeeperPassword = PasswordEncoder.encode(CreateEnsembleOptions.generatePassword());
    @Property(name="zookeeper.server.port", label="ZooKeeper Server Port", description="The zookeeper server binding port", value={"${zookeeper.server.port}"})
    private int zookeeperServerPort = 2181;
    @Property(name="zookeeper.server.connection.port", label="ZooKeeper Client Port", description="The zookeeper server connection port", value={"${zookeeper.server.connection.port}"})
    private int zookeeperServerConnectionPort = 2181;
    @Property(name="profiles.auto.import", label="Auto Import Enabled", description="Flag to automatically import the default profiles", value={"${profiles.auto.import}"})
    private boolean profilesAutoImport = true;
    @Property(name="profiles.auto.import.path", label="Auto Import Enabled", description="Flag to automatically import the default profiles", value={"${profiles.auto.import.path}"})
    private String profilesAutoImportPath = "fabric/import";
    @Property(name="profiles", value={"${profiles}"})
    private Set<String> profiles = Collections.emptySet();
    @Property(name="version", value={"${version}"})
    private String version = ContainerOptions.DEFAULT_VERSION;
    @Property(name="resolver", label="Global Resolver", description="The global resolver", value={"${global.resolver}"})
    private String resolver = "localhostname";
    @Property(name="manualip", label="Global Resolver", description="The global resolver", value={"${manualip}"})
    private String manualip;
    @Property(name="name", label="Container Name", description="The name of the container", value={"${karaf.name}"}, propertyPrivate=true)
    private String name;
    @Property(name="home", label="Container Home", description="The home directory of the container", value={"${karaf.home}"}, propertyPrivate=true)
    private String home;
    @Property(name="zookeeper.url", label="ZooKeeper URL", description="The url to an existing zookeeper ensemble", value={"${zookeeper.url}"}, propertyPrivate=true)
    private String zookeeperUrl;
    private ComponentContext componentContext;

    @Activate
    void activate(ComponentContext componentContext, Map<String, ?> configuration) throws Exception {
        this.componentContext = componentContext;
        this.configurer.configure(configuration, (Object)this);
        org.apache.felix.utils.properties.Properties userProps = new org.apache.felix.utils.properties.Properties();
        try {
            userProps.load(new File(new File(this.home), "etc" + File.separator + "users.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load users from etc/users.properties. No users will be imported.", (Throwable)e);
        }
        this.options = ((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)((CreateEnsembleOptions.Builder)CreateEnsembleOptions.builder().bindAddress(this.bindAddress)).agentEnabled(this.agentAutoStart).ensembleStart(this.ensembleAutoStart).zookeeperPassword(PasswordEncoder.decode(this.zookeeperPassword)).zooKeeperServerPort(this.zookeeperServerPort).zooKeeperServerConnectionPort(this.zookeeperServerConnectionPort).autoImportEnabled(this.profilesAutoImport).importPath(this.profilesAutoImportPath).users((Map)userProps).profiles(this.profiles)).version(this.version)).build();
        BundleContext bundleContext = componentContext.getBundleContext();
        boolean isCreated = this.checkCreated(bundleContext);
        if (!Strings.isNotBlank(this.zookeeperUrl) && !isCreated && this.options.isEnsembleStart()) {
            String connectionUrl = this.getConnectionUrl(this.options);
            ((DataStoreRegistrationHandler)this.registrationHandler.get()).setRegistrationCallback((DataStoreTemplate)new DataStoreBootstrapTemplate(this.name, this.home, connectionUrl, this.options));
            this.createOrUpdateDataStoreConfig(this.options);
            this.createZooKeeeperServerConfig(this.options);
            this.createZooKeeeperClientConfig(connectionUrl, this.options);
            this.markCreated(bundleContext);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    private boolean checkCreated(BundleContext bundleContext) throws IOException {
        org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile(ENSEMBLE_MARKER));
        return props.containsKey("created");
    }

    private void markCreated(BundleContext bundleContext) throws IOException {
        org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(bundleContext.getDataFile(ENSEMBLE_MARKER));
        props.put("created", "true");
        props.save();
    }

    public CreateEnsembleOptions getBootstrapOptions() {
        this.assertValid();
        return this.options;
    }

    public String getConnectionUrl(CreateEnsembleOptions options) throws UnknownHostException {
        int zooKeeperServerConnectionPort = options.getZooKeeperServerConnectionPort();
        String connectionUrl = this.getConnectionAddress(options) + ":" + zooKeeperServerConnectionPort;
        return connectionUrl;
    }

    public void createOrUpdateDataStoreConfig(CreateEnsembleOptions options) throws IOException {
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.datastore", null);
        Hashtable<String, String> properties = config.getProperties();
        if (properties == null || ((Dictionary)properties).isEmpty()) {
            boolean updateConfig = false;
            properties = new Hashtable<String, String>();
            Map dataStoreProperties = options.getDataStoreProperties();
            for (Map.Entry entry : dataStoreProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String oldval = ((Dictionary)properties).put(key, value);
                updateConfig = updateConfig || !value.equals(oldval);
            }
            if (updateConfig) {
                config.update(properties);
            }
        }
    }

    public void createZooKeeeperServerConfig(CreateEnsembleOptions options) throws IOException {
        int serverPort = Ports.mapPortToRange(options.getZooKeeperServerPort(), options.getMinimumPort(), options.getMaximumPort());
        String serverHost = options.getBindAddress();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (options.isAutoImportEnabled()) {
            this.loadPropertiesFrom(properties, options.getImportPath() + "/fabric/configs/versions/1.0/profiles/default/io.fabric8.zookeeper.server.properties");
        }
        ((Dictionary)properties).put("tickTime", String.valueOf(options.getZooKeeperServerTickTime()));
        ((Dictionary)properties).put("initLimit", String.valueOf(options.getZooKeeperServerInitLimit()));
        ((Dictionary)properties).put("syncLimit", String.valueOf(options.getZooKeeperServerSyncLimit()));
        ((Dictionary)properties).put("dataDir", options.getZooKeeperServerDataDir() + File.separator + "0000");
        ((Dictionary)properties).put("clientPort", Integer.toString(serverPort));
        ((Dictionary)properties).put("clientPortAddress", serverHost);
        ((Dictionary)properties).put("fabric.zookeeper.pid", "io.fabric8.zookeeper.server-0000");
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).createFactoryConfiguration("io.fabric8.zookeeper.server", null);
        config.update(properties);
    }

    public void createZooKeeeperClientConfig(String connectionUrl, CreateEnsembleOptions options) throws IOException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (options.isAutoImportEnabled()) {
            this.loadPropertiesFrom(properties, options.getImportPath() + "/fabric/configs/versions/1.0/profiles/default/io.fabric8.zookeeper.properties");
        }
        ((Dictionary)properties).put("zookeeper.url", connectionUrl);
        ((Dictionary)properties).put("zookeeper.timeout", System.getProperties().containsKey("zookeeper.timeout") ? System.getProperties().getProperty("zookeeper.timeout") : "30000");
        ((Dictionary)properties).put("fabric.zookeeper.pid", "io.fabric8.zookeeper");
        ((Dictionary)properties).put("zookeeper.password", PasswordEncoder.encode(options.getZookeeperPassword()));
        Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper", null);
        config.update(properties);
    }

    private String getConnectionAddress(CreateEnsembleOptions options) throws UnknownHostException {
        String oManualIp;
        String oResolver = Strings.isNotBlank(options.getResolver()) ? options.getResolver() : this.resolver;
        String string = oManualIp = Strings.isNotBlank(options.getManualIp()) ? options.getManualIp() : this.manualip;
        if (oResolver.equals("localhostname")) {
            return HostUtils.getLocalHostName();
        }
        if (oResolver.equals("localip")) {
            return HostUtils.getLocalIp();
        }
        if (oResolver.equals("manualip") && oManualIp != null && !oManualIp.isEmpty()) {
            return options.getManualIp();
        }
        return HostUtils.getLocalHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Dictionary<String, Object> dictionary, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                dictionary.put(key, properties.get(key));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.bind((Object)service);
    }

    void unbindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

