/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.maven.indexer;

import io.hawt.config.ConfigFacade;
import io.hawt.maven.indexer.ArtifactDTO;
import io.hawt.maven.indexer.MavenIndexerFacadeMXBean;
import io.hawt.util.FileLocker;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.ContextMemberProvider;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.StaticContextMemberProvider;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.expr.UserInputSearchExpression;
import org.apache.maven.index.search.grouping.GAGrouping;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.AbstractTransferListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenIndexerFacade
extends MBeanSupport
implements MavenIndexerFacadeMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(MavenIndexerFacade.class);
    private static final int SEARCH_LIMIT = 10000;
    private PlexusContainer plexusContainer;
    private Indexer indexer;
    private IndexUpdater indexUpdater;
    private Wagon httpWagon;
    private IndexingContext mergedContext;
    private List<IndexCreator> indexers;
    private boolean updateIndexOnStartup = true;
    private int maximumIndexersPerMachine = 20;
    private String[] repositories = new String[]{"http://repository.jboss.org/nexus/content/repositories/ea@id=ea.jboss..release.repo", "http://repo1.maven.org/maven2@central"};
    private String cacheDirName;
    private File cacheDirectory;
    private Map<String, IndexingContext> indexContexts = new HashMap<String, IndexingContext>();
    private FileLocker fileLock;
    private String lockFileName = "hawtio.lock";
    private final AtomicBoolean indexing = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        LOG.debug("Initializing MavenIndexer ... ");
        this.plexusContainer = new DefaultPlexusContainer();
        this.indexer = (Indexer)this.plexusContainer.lookup(Indexer.class);
        this.indexUpdater = (IndexUpdater)this.plexusContainer.lookup(IndexUpdater.class);
        this.httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
        if (this.indexers == null) {
            this.indexers = new ArrayList<IndexCreator>();
            this.indexers.add((IndexCreator)this.plexusContainer.lookup(IndexCreator.class, "min"));
            this.indexers.add((IndexCreator)this.plexusContainer.lookup(IndexCreator.class, "jarContent"));
            this.indexers.add((IndexCreator)this.plexusContainer.lookup(IndexCreator.class, "maven-plugin"));
        }
        File dir = this.getCacheDirectory();
        LOG.info("Storing maven index files in local directory: " + dir.getAbsolutePath());
        try {
            this.indexing.set(true);
            for (String repository : this.repositories) {
                if (StringUtils.isNotBlank((String)repository)) {
                    String url = repository;
                    String id = repository;
                    int idx = repository.indexOf(64);
                    if (idx > 0) {
                        url = repository.substring(0, idx);
                        id = repository.substring(idx + 1);
                    }
                    File repoDir = new File(dir, id);
                    File cacheDir = new File(repoDir, "cache");
                    File indexDir = new File(repoDir, "index");
                    cacheDir.mkdirs();
                    indexDir.mkdirs();
                    String contextId = id + "-context";
                    IndexingContext repoContext = this.indexer.createIndexingContext(contextId, id, cacheDir, indexDir, url, null, true, true, this.indexers);
                    this.indexContexts.put(id, repoContext);
                }
                File mergedDir = new File(dir, "all");
                File cacheDir = new File(mergedDir, "cache");
                File indexDir = new File(mergedDir, "index");
                StaticContextMemberProvider members = new StaticContextMemberProvider(this.indexContexts.values());
                this.mergedContext = this.indexer.createMergedIndexingContext("all-context", "all", cacheDir, indexDir, true, (ContextMemberProvider)members);
            }
            if (this.updateIndexOnStartup) {
                this.downloadOrUpdateIndices();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to fetch the maven repository indices due to: " + e.getMessage());
            LOG.info("Some or all maven repository data may not be available for searching...");
        }
        finally {
            this.indexing.set(false);
        }
        try {
            super.init();
        }
        catch (Exception e) {
            LOG.error("Failed to register MBean: " + e, (Throwable)e);
        }
        LOG.debug("Initializing MavenIndexer done");
    }

    public void downloadOrUpdateIndices() throws IOException {
        Set<Map.Entry<String, IndexingContext>> entries = this.indexContexts.entrySet();
        if (!entries.isEmpty()) {
            LOG.info("Updating the maven indices. This may take a while, please be patient...");
        }
        for (Map.Entry<String, IndexingContext> entry : entries) {
            final String contextId = entry.getKey();
            IndexingContext context = entry.getValue();
            Date contextTime = context.getTimestamp();
            AbstractTransferListener listener = new AbstractTransferListener(){

                public void transferStarted(TransferEvent transferEvent) {
                    LOG.debug(contextId + ": Downloading " + transferEvent.getResource().getName());
                }

                public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
                }

                public void transferCompleted(TransferEvent transferEvent) {
                    LOG.debug(contextId + ": Download complete");
                }
            };
            WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(this.httpWagon, (TransferListener)listener, null, null);
            IndexUpdateRequest updateRequest = new IndexUpdateRequest(context, (ResourceFetcher)resourceFetcher);
            IndexUpdateResult updateResult = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
            if (updateResult.isFullUpdate()) {
                LOG.debug(contextId + ": Full index update completed on index");
                continue;
            }
            Date timestamp = updateResult.getTimestamp();
            if (timestamp != null && timestamp.equals(contextTime)) {
                LOG.debug(contextId + ": No index update needed, index is up to date!");
                continue;
            }
            LOG.debug(contextId + ": Incremental update happened, change covered " + contextTime + " - " + timestamp + " period.");
        }
        if (!entries.isEmpty()) {
            LOG.info("Completed updating {} maven indices.", (Object)entries.size());
        }
    }

    public void destroy() throws Exception {
        if (this.indexing.get()) {
            LOG.warn("Destroying MavenIndexer while indexing is still in progress, this could lead to errors ... ");
        } else {
            LOG.debug("Destroying MavenIndexer ... ");
        }
        if (this.fileLock != null) {
            this.fileLock.destroy();
        }
        if (this.indexer != null) {
            for (IndexingContext context : this.indexContexts.values()) {
                this.indexer.closeIndexingContext(context, false);
            }
            this.indexContexts.clear();
        }
        super.destroy();
    }

    public boolean isUpdateIndexOnStartup() {
        return this.updateIndexOnStartup;
    }

    public void setUpdateIndexOnStartup(boolean updateIndexOnStartup) {
        this.updateIndexOnStartup = updateIndexOnStartup;
    }

    public List<IndexCreator> getIndexers() {
        return this.indexers;
    }

    public void setIndexers(List<IndexCreator> indexers) {
        this.indexers = indexers;
    }

    @Override
    public String[] getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String[] repositories) {
        this.repositories = repositories;
    }

    public int getMaximumIndexersPerMachine() {
        return this.maximumIndexersPerMachine;
    }

    public void setMaximumIndexersPerMachine(int maximumIndexersPerMachine) {
        this.maximumIndexersPerMachine = maximumIndexersPerMachine;
    }

    public String getCacheDirName() {
        return this.cacheDirName;
    }

    public void setCacheDirName(String cacheDirName) {
        this.cacheDirName = cacheDirName;
    }

    public File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            String name = this.getCacheDirName();
            if (Strings.isNotBlank((String)name)) {
                this.cacheDirectory = new File(name);
            } else {
                File dir = new File(".");
                name = "mavenIndex";
                ConfigFacade configFacade = ConfigFacade.getSingleton();
                if (configFacade != null) {
                    dir = configFacade.getConfigDirectory();
                }
                String postfix = "";
                for (int i = 2; i < this.maximumIndexersPerMachine; ++i) {
                    File tryDir = new File(dir, name + postfix);
                    this.fileLock = FileLocker.getLock((File)new File(tryDir, this.lockFileName));
                    if (this.fileLock != null) {
                        this.cacheDirectory = tryDir;
                        break;
                    }
                    LOG.warn("Cannot lock directory {} as file lock {} present. If there are no other processes running hawtio, then the lock is likely orphaned and can be deleted.", (Object)tryDir, (Object)this.lockFileName);
                    postfix = "-" + i;
                }
                if (this.cacheDirectory == null) {
                    LOG.warn("Could not find a directory inside of " + dir.getAbsolutePath() + " which did not have a lock file " + this.lockFileName + " so giving up after " + this.maximumIndexersPerMachine + " attempt(s).");
                }
            }
        }
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public List<ArtifactDTO> search(String groupId, String artifactId, String version, String packaging, String classifier, String className) throws IOException {
        BooleanQuery bq = this.createQuery(groupId, artifactId, version, packaging, classifier, className);
        return this.searchGrouped((Query)bq);
    }

    @Override
    public List<ArtifactDTO> searchFlat(String groupId, String artifactId, String version, String packaging, String classifier, String className) throws IOException {
        BooleanQuery bq = this.createQuery(groupId, artifactId, version, packaging, classifier, className);
        return this.searchFlat(bq);
    }

    @Override
    public List<ArtifactDTO> searchClasses(String classNameSearchText) throws IOException {
        Query query = this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression(classNameSearchText));
        return this.searchGrouped(query);
    }

    @Override
    public List<ArtifactDTO> searchText(String searchText) throws IOException {
        BooleanQuery bq = this.createTextSearchQuery(searchText);
        return this.searchGrouped((Query)bq);
    }

    @Override
    public List<ArtifactDTO> searchTextAndPackaging(String searchText, String packaging, String classifier) throws IOException {
        BooleanQuery bq = new BooleanQuery();
        if (StringUtils.isNotBlank((String)searchText)) {
            BooleanQuery textQuery = this.createTextSearchQuery(searchText);
            textQuery.setMinimumNumberShouldMatch(1);
            bq.add((Query)textQuery, BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)packaging)) {
            bq.add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression(packaging)), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)classifier)) {
            bq.add(this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression(classifier)), BooleanClause.Occur.MUST);
        }
        return this.searchGrouped((Query)bq);
    }

    public List<ArtifactDTO> searchGrouped(Query query) throws IOException {
        return this.searchGrouped(query, new GAGrouping());
    }

    public List<ArtifactDTO> searchGrouped(Query query, GAGrouping grouping) throws IOException {
        ArrayList<ArtifactDTO> answer = new ArrayList<ArtifactDTO>();
        GroupedSearchResponse response = this.indexer.searchGrouped(new GroupedSearchRequest(query, (Grouping)grouping, this.mergedContext));
        int index = 0;
        for (Map.Entry entry : response.getResults().entrySet()) {
            ArtifactInfo ai = (ArtifactInfo)((ArtifactInfoGroup)entry.getValue()).getArtifactInfos().iterator().next();
            ArtifactDTO dto = this.createArtifactDTO(ai);
            answer.add(dto);
            if (++index <= 10000) continue;
            break;
        }
        return answer;
    }

    public List<ArtifactDTO> searchFlat(BooleanQuery q) throws IOException {
        ArrayList<ArtifactDTO> answer = new ArrayList<ArtifactDTO>();
        FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest((Query)q, this.mergedContext));
        int index = 0;
        for (ArtifactInfo ai : response.getResults()) {
            ArtifactDTO dto = this.createArtifactDTO(ai);
            answer.add(dto);
            if (++index <= 10000) continue;
            break;
        }
        return answer;
    }

    @Override
    public List<String> groupIdComplete(String groupId, String packaging, String classifier) throws IOException {
        BooleanQuery bq = this.createQuery(this.endWithStarIfNotBlank(groupId), null, null, packaging, classifier, null);
        TreeSet<String> set = new TreeSet<String>();
        FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest((Query)bq, this.mergedContext));
        int index = 0;
        for (ArtifactInfo ai : response.getResults()) {
            set.add(ai.groupId);
            if (++index <= 10000) continue;
            break;
        }
        return new ArrayList<String>(set);
    }

    @Override
    public List<String> artifactIdComplete(String groupId, String artifactId, String packaging, String classifier) throws IOException {
        BooleanQuery bq = this.createQuery(groupId, this.endWithStarIfNotBlank(artifactId), null, packaging, classifier, null);
        TreeSet<String> set = new TreeSet<String>();
        FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest((Query)bq, this.mergedContext));
        int index = 0;
        for (ArtifactInfo ai : response.getResults()) {
            set.add(ai.artifactId);
            if (++index <= 10000) continue;
            break;
        }
        return new ArrayList<String>(set);
    }

    @Override
    public List<String> versionComplete(String groupId, String artifactId, String version, String packaging, String classifier) throws IOException {
        BooleanQuery bq = this.createQuery(groupId, artifactId, this.endWithStarIfNotBlank(version), packaging, classifier, null);
        TreeSet<String> set = new TreeSet<String>();
        int index = 0;
        FlatSearchResponse response = this.indexer.searchFlat(new FlatSearchRequest((Query)bq, this.mergedContext));
        for (ArtifactInfo ai : response.getResults()) {
            set.add(ai.version);
            if (++index <= 10000) continue;
            break;
        }
        return new ArrayList<String>(set);
    }

    protected BooleanQuery createQuery(String groupId, String artifactId, String version, String packaging, String classifier, String className) {
        BooleanQuery bq = new BooleanQuery();
        if (StringUtils.isNotBlank((String)groupId)) {
            bq.add(this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression(groupId)), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)artifactId)) {
            bq.add(this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression(artifactId)), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)version)) {
            bq.add(this.indexer.constructQuery(MAVEN.VERSION, (SearchExpression)new SourcedSearchExpression(version)), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)packaging)) {
            bq.add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression(packaging)), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)classifier)) {
            bq.add(this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression(classifier)), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)className)) {
            bq.add(this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression(className)), BooleanClause.Occur.MUST);
        }
        return bq;
    }

    protected BooleanQuery createTextSearchQuery(String searchText) {
        BooleanQuery bq = new BooleanQuery();
        if (StringUtils.isNotBlank((String)searchText)) {
            Field[] names = new Field[]{MAVEN.GROUP_ID, MAVEN.ARTIFACT_ID, MAVEN.VERSION, MAVEN.NAME};
            UserInputSearchExpression input = new UserInputSearchExpression(searchText);
            for (Field name : names) {
                bq.add(this.indexer.constructQuery(name, (SearchExpression)input), BooleanClause.Occur.SHOULD);
            }
        }
        return bq;
    }

    protected String getDefaultObjectName() {
        return "hawtio:type=Indexer";
    }

    protected String endWithStarIfNotBlank(String text) {
        if (StringUtils.isNotBlank((String)text)) {
            if (!text.endsWith("*")) {
                return StringUtils.trim((String)text) + "*";
            }
            return StringUtils.trim((String)text);
        }
        return text;
    }

    protected ArtifactDTO createArtifactDTO(ArtifactInfo ai) {
        return new ArtifactDTO(ai.groupId, ai.artifactId, ai.version, ai.packaging, ai.classifier, ai.description, ai.lastModified, ai.name, ai.bundleSymbolicName);
    }
}

