/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.ProfileRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FabricRequirements {
    private List<ProfileRequirements> profileRequirements = new ArrayList<ProfileRequirements>();
    private String version;

    public FabricRequirements() {
    }

    public FabricRequirements(List<ProfileRequirements> profileRequirements) {
        this();
        this.profileRequirements = profileRequirements;
        this.sortProfilesRequirements();
    }

    public String toString() {
        return "FabricRequirements" + this.profileRequirements;
    }

    public List<ProfileRequirements> getProfileRequirements() {
        return this.profileRequirements;
    }

    public void setProfileRequirements(List<ProfileRequirements> profileRequirements) {
        this.profileRequirements = profileRequirements;
        this.sortProfilesRequirements();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProfileRequirements getOrCreateProfileRequirement(String profile) {
        ProfileRequirements requirements = this.findProfileRequirements(profile);
        if (requirements == null) {
            requirements = new ProfileRequirements(profile);
            this.profileRequirements.add(requirements);
        }
        return requirements;
    }

    public ProfileRequirements findProfileRequirements(String profile) {
        for (ProfileRequirements profileRequirement : this.profileRequirements) {
            if (!profile.equals(profileRequirement.getProfile())) continue;
            return profileRequirement;
        }
        return null;
    }

    public boolean removeProfileRequirements(String profile) {
        ProfileRequirements requirements = this.findProfileRequirements(profile);
        if (requirements != null) {
            this.profileRequirements.remove(requirements);
            return true;
        }
        return false;
    }

    public void addOrUpdateProfileRequirements(ProfileRequirements requirement) {
        this.removeProfileRequirements(requirement.getProfile());
        this.profileRequirements.add(requirement);
        this.sortProfilesRequirements();
    }

    protected void sortProfilesRequirements() {
        Collections.sort(this.profileRequirements);
    }

    public void removeEmptyRequirements() {
        Iterator<ProfileRequirements> iterator = this.profileRequirements.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().checkIsEmpty()) continue;
            iterator.remove();
        }
    }

    public boolean hasMinimumInstances(String profileId) {
        ProfileRequirements profileRequirement = this.findProfileRequirements(profileId);
        if (profileRequirement != null) {
            return profileRequirement.hasMinimumInstances();
        }
        return false;
    }
}

