/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dosgi.util;

import io.fabric8.dosgi.impl.EndpointDescription;
import io.fabric8.dosgi.util.UuidGenerator;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.osgi.framework.BundleContext;

public class Utils {
    public static final String FRAMEWORK_UUID = "org.osgi.framework.uuid";
    private static final String REMOTE_SERVICES_ADMIN_NS = "http://www.osgi.org/xmlns/rsa/v1.0.0";
    private static final String ENDPOINT_DESCRIPTIONS = "endpoint-descriptions";
    private static final String ENDPOINT_DESCRIPTION = "endpoint-description";
    private static final String PROPERTY = "property";
    private static final String ARRAY = "array";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String VALUE_TYPE = "value-type";
    private static final Map<String, Class> TYPES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUUID(BundleContext bundleContext) {
        String uuid = bundleContext.getProperty(FRAMEWORK_UUID);
        if (uuid != null) return uuid;
        String string = FRAMEWORK_UUID;
        synchronized (FRAMEWORK_UUID) {
            uuid = bundleContext.getProperty(FRAMEWORK_UUID);
            if (uuid != null) return uuid;
            uuid = UuidGenerator.getUUID();
            System.setProperty(FRAMEWORK_UUID, uuid);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return uuid;
        }
    }

    public static Set<String> normalize(Object object) {
        HashSet<String> strings;
        block3: {
            block4: {
                block2: {
                    strings = new HashSet<String>();
                    if (!(object instanceof String)) break block2;
                    strings.add((String)object);
                    break block3;
                }
                if (!(object instanceof String[])) break block4;
                for (String s : (String[])object) {
                    strings.add(s);
                }
                break block3;
            }
            if (!(object instanceof Collection)) break block3;
            for (Object o : (Collection)object) {
                if (!(o instanceof String)) continue;
                strings.add((String)o);
            }
        }
        return strings;
    }

    public static String getEndpointDescriptionXML(EndpointDescription endpoint) throws XMLStreamException {
        Map<String, Object> properties = endpoint.getProperties();
        StringWriter writer = new StringWriter();
        XMLStreamWriter xml = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
        xml.writeStartDocument();
        xml.setDefaultNamespace(REMOTE_SERVICES_ADMIN_NS);
        xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, ENDPOINT_DESCRIPTIONS);
        xml.writeNamespace("", REMOTE_SERVICES_ADMIN_NS);
        xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, ENDPOINT_DESCRIPTION);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, PROPERTY);
            xml.writeAttribute(NAME, key);
            if (val.getClass().isArray()) {
                Utils.setValueType(xml, val.getClass().getComponentType().getName());
                xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, ARRAY);
                int l = Array.getLength(val);
                for (int i = 0; i < l; ++i) {
                    xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, VALUE);
                    xml.writeCharacters(Array.get(val, i).toString());
                    xml.writeEndElement();
                }
                xml.writeEndElement();
            } else if (val instanceof List) {
                xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, LIST);
                Utils.handleCollectionValue(xml, (Collection)val);
                xml.writeEndElement();
            } else if (val instanceof Set) {
                xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, SET);
                Utils.handleCollectionValue(xml, (Collection)val);
                xml.writeEndElement();
            } else {
                xml.writeAttribute(VALUE, val.toString());
                Utils.setValueType(xml, val.getClass().getName());
            }
            xml.writeEndElement();
        }
        xml.writeEndElement();
        xml.writeEndElement();
        xml.writeEndDocument();
        xml.close();
        return writer.toString();
    }

    private static void handleCollectionValue(XMLStreamWriter xml, Collection val) throws XMLStreamException {
        for (Object o : val) {
            xml.writeStartElement(REMOTE_SERVICES_ADMIN_NS, VALUE);
            Utils.setValueType(xml, o.getClass().getName());
            xml.writeCharacters(o.toString());
            xml.writeEndElement();
        }
    }

    private static void setValueType(XMLStreamWriter xml, String dataType) throws XMLStreamException {
        if (dataType.equals(String.class.getName())) {
            return;
        }
        if (dataType.startsWith("java.lang.")) {
            dataType = dataType.substring("java.lang.".length());
        }
        xml.writeAttribute(VALUE_TYPE, dataType);
    }

    public static EndpointDescription getEndpointDescription(String data) throws XMLStreamException {
        List<EndpointDescription> endpoints = Utils.getEndpointDescriptions(data);
        if (endpoints == null || endpoints.size() != 1) {
            throw new IllegalArgumentException();
        }
        return endpoints.get(0);
    }

    public static List<EndpointDescription> getEndpointDescriptions(String data) throws XMLStreamException {
        ArrayList<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
        HashMap<String, Object> properties = null;
        String key = null;
        String type = null;
        String value = null;
        Object val = null;
        String txt = null;
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(data));
        while (true) {
            int code = reader.next();
            switch (code) {
                case 7: {
                    break;
                }
                case 1: {
                    if (ENDPOINT_DESCRIPTION.equals(reader.getLocalName())) {
                        properties = new HashMap<String, Object>();
                        break;
                    }
                    if (PROPERTY.equals(reader.getLocalName())) {
                        key = reader.getAttributeValue(null, NAME);
                        type = reader.getAttributeValue(null, VALUE_TYPE);
                        value = reader.getAttributeValue(null, VALUE);
                        val = null;
                        break;
                    }
                    if (ARRAY.equals(reader.getLocalName())) {
                        val = Array.newInstance(TYPES.get(type == null ? "String" : type), 0);
                        break;
                    }
                    if (SET.equals(reader.getLocalName())) {
                        val = new HashSet();
                        break;
                    }
                    if (LIST.equals(reader.getLocalName())) {
                        val = new ArrayList();
                        break;
                    }
                    if (!VALUE.equals(reader.getLocalName())) break;
                    txt = null;
                    break;
                }
                case 4: {
                    if (txt == null) {
                        txt = reader.getText();
                        break;
                    }
                    txt = txt + reader.getText();
                    break;
                }
                case 2: {
                    if (ENDPOINT_DESCRIPTION.equals(reader.getLocalName())) {
                        endpoints.add(new EndpointDescription(properties));
                        properties = null;
                        break;
                    }
                    if (PROPERTY.equals(reader.getLocalName())) {
                        if (key == null || val == null && value == null || val != null && value != null) {
                            throw new IllegalArgumentException();
                        }
                        if (value != null) {
                            val = Utils.instantiate(type == null ? "String" : type, value);
                        }
                        properties.put(key, val);
                        break;
                    }
                    if (!VALUE.equals(reader.getLocalName())) break;
                    if (val.getClass().isArray()) {
                        int len = Array.getLength(val);
                        Object a = Array.newInstance(TYPES.get(type == null ? "String" : type), len + 1);
                        System.arraycopy(val, 0, a, 0, len);
                        Array.set(a, len, Utils.instantiate(type == null ? "String" : type, txt));
                        val = a;
                        break;
                    }
                    ((Collection)val).add(Utils.instantiate(type == null ? "String" : type, txt));
                    break;
                }
                case 8: {
                    return endpoints;
                }
            }
        }
    }

    private static Object instantiate(String type, String value) {
        if ("String".equals(type)) {
            return value;
        }
        value = value.trim();
        String boxedType = null;
        if ("long".equals(type)) {
            boxedType = "Long";
        } else if ("double".equals(type)) {
            boxedType = "Double";
        } else if ("float".equals(type)) {
            boxedType = "Float";
        } else if ("int".equals(type)) {
            boxedType = "Integer";
        } else if ("byte".equals(type)) {
            boxedType = "Byte";
        } else if ("char".equals(type)) {
            boxedType = "Character";
        } else if ("boolean".equals(type)) {
            boxedType = "Boolean";
        } else if ("short".equals(type)) {
            boxedType = "Short";
        }
        if (boxedType == null) {
            boxedType = type;
        }
        String javaType = "java.lang." + boxedType;
        if (boxedType.equals("Character")) {
            return Character.valueOf(value.charAt(0));
        }
        try {
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(javaType);
            Constructor<?> ctor = cls.getConstructor(String.class);
            return ctor.newInstance(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        HashMap<String, Class> types = new HashMap<String, Class>();
        types.put("long", Long.TYPE);
        types.put("Long", Long.class);
        types.put("double", Double.TYPE);
        types.put("Double", Double.class);
        types.put("float", Float.TYPE);
        types.put("Float", Float.class);
        types.put("int", Integer.TYPE);
        types.put("Integer", Integer.class);
        types.put("byte", Byte.TYPE);
        types.put("Byte", Byte.class);
        types.put("char", Character.TYPE);
        types.put("Character", Character.class);
        types.put("boolean", Boolean.TYPE);
        types.put("Double", Double.class);
        types.put("short", Short.TYPE);
        types.put("Short", Short.class);
        types.put("String", String.class);
        TYPES = types;
    }
}

