/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework.wiring;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.codec.BundleWiringData;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.jmx.framework.wiring.BundleWiringStateMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWiringState
implements BundleWiringStateMBean {
    private final BundleContext bundleContext;
    private final Logger logger;

    public BundleWiringState(BundleContext bundleContext, Logger logger) {
        this.bundleContext = bundleContext;
        this.logger = logger;
    }

    public CompositeData[] getCurrentRevisionDeclaredRequirements(long bundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return BundleWiringData.getRequirementsCompositeData(revision.getDeclaredRequirements(namespace));
    }

    public CompositeData[] getCurrentRevisionDeclaredCapabilities(long bundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return BundleWiringData.getCapabilitiesCompositeData(revision.getDeclaredCapabilities(namespace));
    }

    public CompositeData getCurrentWiring(long bundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        BundleRevision currentRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        Map<BundleRevision, Integer> revisionIDMap = this.getCurrentRevisionTransitiveRevisionsClosure(bundleId, namespace);
        return this.getRevisionWiring(currentRevision, 0, namespace, revisionIDMap);
    }

    public TabularData getCurrentWiringClosure(long rootBundleId, String namespace) throws IOException {
        Map<BundleRevision, Integer> revisionIDMap = this.getCurrentRevisionTransitiveRevisionsClosure(rootBundleId, namespace);
        TabularDataSupport td = new TabularDataSupport(BundleWiringStateMBean.BUNDLES_WIRING_TYPE);
        for (Map.Entry<BundleRevision, Integer> entry : revisionIDMap.entrySet()) {
            td.put(this.getRevisionWiring(entry.getKey(), entry.getValue(), namespace, revisionIDMap));
        }
        return td;
    }

    private Map<BundleRevision, Integer> getCurrentRevisionTransitiveRevisionsClosure(long rootBundleId, String namespace) throws IOException {
        Bundle rootBundle = FrameworkUtils.resolveBundle(this.bundleContext, rootBundleId);
        BundleRevision rootRevision = (BundleRevision)rootBundle.adapt(BundleRevision.class);
        return this.getRevisionTransitiveClosure(rootRevision, namespace);
    }

    private Map<BundleRevision, Integer> getRevisionTransitiveClosure(BundleRevision rootRevision, String namespace) {
        HashMap<BundleRevision, Integer> revisionIDMap = new HashMap<BundleRevision, Integer>();
        this.populateTransitiveRevisions(namespace, rootRevision, revisionIDMap);
        revisionIDMap.put(rootRevision, 0);
        return revisionIDMap;
    }

    private void populateTransitiveRevisions(String namespace, BundleRevision rootRevision, Map<BundleRevision, Integer> allRevisions) {
        allRevisions.put(rootRevision, System.identityHashCode(rootRevision));
        BundleWiring wiring = rootRevision.getWiring();
        if (wiring == null) {
            return;
        }
        List requiredWires = wiring.getRequiredWires(namespace);
        for (BundleWire wire : requiredWires) {
            BundleRevision revision = wire.getCapability().getRevision();
            if (allRevisions.containsKey(revision)) continue;
            this.populateTransitiveRevisions(namespace, revision, allRevisions);
        }
        List providedWires = wiring.getProvidedWires(namespace);
        for (BundleWire wire : providedWires) {
            BundleRevision revision = wire.getRequirement().getRevision();
            if (allRevisions.containsKey(revision)) continue;
            this.populateTransitiveRevisions(namespace, revision, allRevisions);
        }
    }

    private CompositeData getRevisionWiring(BundleRevision revision, int revisionID, String namespace, Map<BundleRevision, Integer> revisionIDMap) {
        BundleWiring wiring = revision.getWiring();
        List capabilities = wiring.getCapabilities(namespace);
        List requirements = wiring.getRequirements(namespace);
        List providedWires = wiring.getProvidedWires(namespace);
        List requiredWires = wiring.getRequiredWires(namespace);
        BundleWiringData data = new BundleWiringData(wiring.getBundle().getBundleId(), revisionID, capabilities, requirements, providedWires, requiredWires, revisionIDMap);
        return data.toCompositeData();
    }

    public TabularData getRevisionsDeclaredRequirements(long bundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        TabularDataSupport td = new TabularDataSupport(BundleWiringStateMBean.REVISIONS_REQUIREMENTS_TYPE);
        for (BundleRevision revision : revisions.getRevisions()) {
            td.put(BundleWiringData.getRevisionRequirements(System.identityHashCode(revision), revision.getDeclaredRequirements(namespace)));
        }
        return td;
    }

    public TabularData getRevisionsDeclaredCapabilities(long bundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        TabularDataSupport td = new TabularDataSupport(BundleWiringStateMBean.REVISIONS_CAPABILITIES_TYPE);
        for (BundleRevision revision : revisions.getRevisions()) {
            td.put(BundleWiringData.getRevisionCapabilities(System.identityHashCode(revision), revision.getDeclaredCapabilities(namespace)));
        }
        return td;
    }

    public TabularData getRevisionsWiring(long bundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        TabularDataSupport td = new TabularDataSupport(BundleWiringStateMBean.BUNDLES_WIRING_TYPE);
        for (BundleRevision revision : revisions.getRevisions()) {
            Map<BundleRevision, Integer> revisionIDMap = this.getRevisionTransitiveClosure(revision, namespace);
            td.put(this.getRevisionWiring(revision, System.identityHashCode(revision), namespace, revisionIDMap));
        }
        return td;
    }

    public TabularData getRevisionsWiringClosure(long rootBundleId, String namespace) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, rootBundleId);
        BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        HashMap<BundleRevision, Integer> revisionIDMap = new HashMap<BundleRevision, Integer>();
        for (BundleRevision revision : revisions.getRevisions()) {
            this.populateTransitiveRevisions(namespace, revision, revisionIDMap);
        }
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        revisionIDMap.put(revision, 0);
        TabularDataSupport td = new TabularDataSupport(BundleWiringStateMBean.BUNDLES_WIRING_TYPE);
        for (Map.Entry entry : revisionIDMap.entrySet()) {
            td.put(this.getRevisionWiring((BundleRevision)entry.getKey(), (Integer)entry.getValue(), namespace, revisionIDMap));
        }
        return td;
    }
}

