/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOHelper {
    public static final int BUFFER_SIZE = 65536;
    private static final transient Logger LOG = LoggerFactory.getLogger(IOHelper.class);

    public static String readFully(File file) throws IOException {
        return IOHelper.readFully(new BufferedReader(new FileReader(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(65536);
        char[] buf = new char[65536];
        try {
            int len;
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            IOHelper.close(reader, "reader", LOG);
        }
        return sb.toString();
    }

    public static void close(Closeable closeable, String name, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (log == null) {
                    log = LOG;
                }
                if (name != null) {
                    log.warn("Cannot close: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
                }
                log.warn("Cannot close. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void write(File file, String text) throws IOException {
        IOHelper.write(file, text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String text, boolean append) throws IOException {
        FileWriter writer = new FileWriter(file, append);
        try {
            writer.write(text);
        }
        finally {
            writer.close();
        }
    }

    public static int copy(Reader input, Writer output) throws IOException {
        return IOHelper.copy(input, output, 65536);
    }

    public static int copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }
}

