/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.AbstractMessageStore;
import org.apache.activemq.store.IndexListener;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ByteSequenceData;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCMessageStore
extends AbstractMessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCMessageStore.class);
    protected final WireFormat wireFormat;
    protected final JDBCAdapter adapter;
    protected final JDBCPersistenceAdapter persistenceAdapter;
    protected AtomicLong lastRecoveredSequenceId = new AtomicLong(-1L);
    protected AtomicLong lastRecoveredPriority = new AtomicLong(126L);
    final Set<Long> recoveredAdditions = new LinkedHashSet<Long>();
    protected ActiveMQMessageAudit audit;
    protected final List<Long> pendingAdditions = new LinkedList<Long>();

    public JDBCMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQDestination destination, ActiveMQMessageAudit audit) throws IOException {
        super(destination);
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.wireFormat = wireFormat;
        this.audit = audit;
        if (destination.isQueue() && persistenceAdapter.getBrokerService().shouldRecordVirtualDestination(destination)) {
            this.recordDestinationCreation(destination);
        }
    }

    private void recordDestinationCreation(ActiveMQDestination destination) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            if (this.adapter.doGetLastAckedDurableSubscriberMessageId(c, destination, destination.getQualifiedName(), destination.getQualifiedName()) < 0L) {
                this.adapter.doRecordDestination(c, destination);
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to record destination: " + destination + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(ConnectionContext context, final Message message) throws IOException {
        long sequenceId;
        byte[] data;
        MessageId messageId = message.getMessageId();
        if (this.audit != null && this.audit.isDuplicate(message)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.destination.getPhysicalName() + " ignoring duplicated (add) message, already stored: " + messageId);
            }
            return;
        }
        try {
            ByteSequence packet = this.wireFormat.marshal(message);
            data = ByteSequenceData.toByteArray(packet);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        List<Long> list = this.pendingAdditions;
        synchronized (list) {
            final long sequence = sequenceId = this.persistenceAdapter.getNextSequenceId();
            this.pendingAdditions.add(sequence);
            c.onCompletion(new Runnable(){

                @Override
                public void run() {
                    message.getMessageId().setFutureOrSequenceLong(sequence);
                    message.getMessageId().setEntryLocator(sequence);
                }
            });
            if (this.indexListener != null) {
                this.indexListener.onAdd(new IndexListener.MessageContext(context, message, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<Long> list = JDBCMessageStore.this.pendingAdditions;
                        synchronized (list) {
                            JDBCMessageStore.this.pendingAdditions.remove(sequence);
                        }
                    }
                }));
            } else {
                this.pendingAdditions.remove(sequence);
            }
        }
        try {
            this.adapter.doAddMessage(c, sequenceId, messageId, this.destination, data, message.getExpiration(), this.isPrioritizedMessages() ? message.getPriority() : (byte)0, context != null ? context.getXid() : null);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
        this.onAdd(message, sequenceId, message.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long minPendingSequeunceId() {
        List<Long> list = this.pendingAdditions;
        synchronized (list) {
            if (!this.pendingAdditions.isEmpty()) {
                return this.pendingAdditions.get(0);
            }
            return this.persistenceAdapter.sequenceGenerator.getLastSequenceId() + 1L;
        }
    }

    @Override
    public void updateMessage(Message message) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doUpdateMessage(c, this.destination, message.getMessageId(), ByteSequenceData.toByteArray(this.wireFormat.marshal(message)));
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to update message: " + message.getMessageId() + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    protected void onAdd(Message message, long sequenceId, byte priority) {
        if (message.getTransactionId() != null && message.getTransactionId().isXATransaction() && this.lastRecoveredSequenceId.get() > 0L && sequenceId < this.lastRecoveredSequenceId.get()) {
            this.recoveredAdditions.add(sequenceId);
        }
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doAddMessageReference(c, this.persistenceAdapter.getNextSequenceId(), messageId, this.destination, expirationTime, messageRef);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    @Override
    public Message getMessage(MessageId messageId) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            Message answer;
            byte[] data = this.adapter.doGetMessage(c, messageId);
            if (data == null) {
                Message message = null;
                return message;
            }
            Message message = answer = (Message)this.wireFormat.unmarshal(new ByteSequence(data));
            return message;
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public String getMessageReference(MessageId messageId) throws IOException {
        long id = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            String string = this.adapter.doGetMessageReference(c, id);
            return string;
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    @Override
    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        long seq = ack.getLastMessageId().getFutureOrSequenceLong() != null ? (Long)ack.getLastMessageId().getFutureOrSequenceLong() : this.persistenceAdapter.getStoreSequenceIdForMessageId(ack.getLastMessageId(), this.destination)[0];
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doRemoveMessage(c, seq, context != null ? context.getXid() : null);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + ack.getLastMessageId() + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    @Override
    public void recover(final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doRecover(c, this.destination, new JDBCMessageRecoveryListener(){

                @Override
                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    return listener.recoverMessage(msg);
                }

                @Override
                public boolean recoverMessageReference(String reference) throws Exception {
                    return listener.recoverMessageReference(new MessageId(reference));
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to recover container. Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    @Override
    public void removeAllMessages(ConnectionContext context) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doRemoveAllMessages(c, this.destination);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker remove all messages: " + e, e);
        }
        finally {
            c.close();
        }
    }

    @Override
    public int getMessageCount() throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            result = this.adapter.doGetMessageCount(c, this.destination);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to get Message Count: " + this.destination + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverNextMessages(int maxReturned, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            if (!this.recoveredAdditions.isEmpty()) {
                Iterator<Long> iterator = this.recoveredAdditions.iterator();
                while (iterator.hasNext()) {
                    Long sequenceId = iterator.next();
                    iterator.remove();
                    --maxReturned;
                    if (sequenceId > this.lastRecoveredSequenceId.get()) continue;
                    Message msg = (Message)this.wireFormat.unmarshal(new ByteSequence(this.adapter.doGetMessageById(c, sequenceId)));
                    LOG.trace("recovered add {} {}", (Object)this, (Object)msg.getMessageId());
                    listener.recoverMessage(msg);
                }
            }
            this.adapter.doRecoverNextMessages(c, this.destination, this.minPendingSequeunceId(), this.lastRecoveredSequenceId.get(), this.lastRecoveredPriority.get(), maxReturned, this.isPrioritizedMessages(), new JDBCMessageRecoveryListener(){

                @Override
                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    msg.getMessageId().setFutureOrSequenceLong(sequenceId);
                    listener.recoverMessage(msg);
                    JDBCMessageStore.this.lastRecoveredSequenceId.set(sequenceId);
                    JDBCMessageStore.this.lastRecoveredPriority.set(msg.getPriority());
                    return true;
                }

                @Override
                public boolean recoverMessageReference(String reference) throws Exception {
                    if (listener.hasSpace()) {
                        listener.recoverMessageReference(new MessageId(reference));
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
        }
        finally {
            c.close();
        }
    }

    @Override
    public void resetBatching() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.destination.getPhysicalName() + " resetBatching, existing last recovered seqId: " + this.lastRecoveredSequenceId.get());
        }
        this.lastRecoveredSequenceId.set(-1L);
        this.lastRecoveredPriority.set(126L);
    }

    @Override
    public void setBatch(MessageId messageId) {
        try {
            long[] storedValues = this.persistenceAdapter.getStoreSequenceIdForMessageId(messageId, this.destination);
            this.lastRecoveredSequenceId.set(storedValues[0]);
            this.lastRecoveredPriority.set(storedValues[1]);
        }
        catch (IOException ignoredAsAlreadyLogged) {
            this.lastRecoveredSequenceId.set(-1L);
            this.lastRecoveredPriority.set(126L);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.destination.getPhysicalName() + " setBatch: new sequenceId: " + this.lastRecoveredSequenceId.get() + ", priority: " + this.lastRecoveredPriority.get());
        }
    }

    @Override
    public void setPrioritizedMessages(boolean prioritizedMessages) {
        super.setPrioritizedMessages(prioritizedMessages);
    }

    class Duration {
        static final int LIMIT = 100;
        final long start = System.currentTimeMillis();
        final String name;

        Duration(String name) {
            this.name = name;
        }

        void end() {
            this.end(null);
        }

        void end(Object o) {
            long duration = System.currentTimeMillis() - this.start;
            if (duration > 100L) {
                System.err.println(this.name + " took a long time: " + duration + "ms " + o);
            }
        }
    }
}

