/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.MQTTWireFormat;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.CONNECT;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PINGREQ;
import org.fusesource.mqtt.codec.PINGRESP;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTTransportFilter
extends TransportFilter
implements MQTTTransport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTTransportFilter.class);
    private static final Logger TRACE = LoggerFactory.getLogger((String)(MQTTTransportFilter.class.getPackage().getName() + ".MQTTIO"));
    private final MQTTProtocolConverter protocolConverter;
    private MQTTInactivityMonitor monitor;
    private MQTTWireFormat wireFormat;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private boolean trace;
    private final Object sendLock = new Object();

    public MQTTTransportFilter(Transport next, WireFormat wireFormat, BrokerService brokerService) {
        super(next);
        this.protocolConverter = new MQTTProtocolConverter(this, brokerService);
        if (wireFormat instanceof MQTTWireFormat) {
            this.wireFormat = (MQTTWireFormat)wireFormat;
        }
    }

    @Override
    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onActiveMQCommand(command);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void onCommand(Object command) {
        try {
            MQTTFrame frame = (MQTTFrame)command;
            if (this.trace) {
                TRACE.trace("Received: " + MQTTTransportFilter.toString(frame));
            }
            this.protocolConverter.onMQTTCommand(frame);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create((Exception)((Object)e)));
        }
    }

    @Override
    public void sendToActiveMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToMQTT(MQTTFrame command) throws IOException {
        if (!this.stopped.get()) {
            Transport n;
            if (this.trace) {
                TRACE.trace("Sending : " + MQTTTransportFilter.toString(command));
            }
            if ((n = this.next) != null) {
                Object object = this.sendLock;
                synchronized (object) {
                    n.oneway(command);
                }
            }
        }
    }

    private static String toString(MQTTFrame frame) {
        if (frame == null) {
            return null;
        }
        try {
            switch (frame.messageType()) {
                case 12: {
                    return new PINGREQ().decode(frame).toString();
                }
                case 13: {
                    return new PINGRESP().decode(frame).toString();
                }
                case 1: {
                    return new CONNECT().decode(frame).toString();
                }
                case 14: {
                    return new DISCONNECT().decode(frame).toString();
                }
                case 8: {
                    return new SUBSCRIBE().decode(frame).toString();
                }
                case 10: {
                    return new UNSUBSCRIBE().decode(frame).toString();
                }
                case 3: {
                    return new PUBLISH().decode(frame).toString();
                }
                case 4: {
                    return new PUBACK().decode(frame).toString();
                }
                case 5: {
                    return new PUBREC().decode(frame).toString();
                }
                case 6: {
                    return new PUBREL().decode(frame).toString();
                }
                case 7: {
                    return new PUBCOMP().decode(frame).toString();
                }
                case 2: {
                    return new CONNACK().decode(frame).toString();
                }
                case 9: {
                    return new SUBACK().decode(frame).toString();
                }
            }
            return frame.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return frame.toString();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            super.stop();
        }
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        if (this.next instanceof SslTransport) {
            X509Certificate[] peerCerts = ((SslTransport)this.next).getPeerCertificates();
            if (this.trace && peerCerts != null) {
                LOG.debug("Peer Identity has been verified\n");
            }
            return peerCerts;
        }
        return null;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public MQTTInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    public void setInactivityMonitor(MQTTInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public MQTTWireFormat getWireFormat() {
        return this.wireFormat;
    }

    @Override
    public void onException(IOException error) {
        this.protocolConverter.onTransportError();
        super.onException(error);
    }

    public long getDefaultKeepAlive() {
        return this.protocolConverter != null ? this.protocolConverter.getDefaultKeepAlive() : -1L;
    }

    public void setDefaultKeepAlive(long defaultHeartBeat) {
        this.protocolConverter.setDefaultKeepAlive(defaultHeartBeat);
    }

    public boolean getPublishDollarTopics() {
        return this.protocolConverter != null && this.protocolConverter.getPublishDollarTopics();
    }

    public void setPublishDollarTopics(boolean publishDollarTopics) {
        this.protocolConverter.setPublishDollarTopics(publishDollarTopics);
    }

    public int getActiveMQSubscriptionPrefetch() {
        return this.protocolConverter.getActiveMQSubscriptionPrefetch();
    }

    public void setActiveMQSubscriptionPrefetch(int activeMQSubscriptionPrefetch) {
        this.protocolConverter.setActiveMQSubscriptionPrefetch(activeMQSubscriptionPrefetch);
    }
}

