/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(name="profile-refresh", scope="fabric", description="Performs a change to the profile, that triggers the deployment agent. It's intended to be used for scanning for snapshot changes", detailedDescription="classpath:profileRefresh.txt")
public class ProfileRefresh
extends FabricCommand {
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Argument(index=1, name="version", description="The version of the profile to edit. Defaults to the current default version.", required=false, multiValued=false)
    private String versionName = "1.0";

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateProfileName(this.profileName);
        Version version = this.versionName != null ? this.fabricService.getVersion(this.versionName) : this.fabricService.getDefaultVersion();
        Profile profile = version.getProfile(this.profileName);
        if (profile == null) {
            throw new IllegalArgumentException("No profile found with name:" + this.profileName + " and version:" + version.getId());
        }
        profile.refresh();
        return null;
    }
}

