/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.monitor.fs.FsStats;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.network.NetworkStats;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.elasticsearch.transport.TransportStats;

public class NodeStats
extends NodeOperationResponse {
    private long timestamp;
    @Nullable
    private String hostname;
    @Nullable
    private NodeIndicesStats indices;
    @Nullable
    private OsStats os;
    @Nullable
    private ProcessStats process;
    @Nullable
    private JvmStats jvm;
    @Nullable
    private ThreadPoolStats threadPool;
    @Nullable
    private NetworkStats network;
    @Nullable
    private FsStats fs;
    @Nullable
    private TransportStats transport;
    @Nullable
    private HttpStats http;

    NodeStats() {
    }

    public NodeStats(DiscoveryNode node, long timestamp, @Nullable String hostname, @Nullable NodeIndicesStats indices, @Nullable OsStats os, @Nullable ProcessStats process, @Nullable JvmStats jvm, @Nullable ThreadPoolStats threadPool, @Nullable NetworkStats network, @Nullable FsStats fs, @Nullable TransportStats transport, @Nullable HttpStats http) {
        super(node);
        this.timestamp = timestamp;
        this.hostname = hostname;
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.network = network;
        this.fs = fs;
        this.transport = transport;
        this.http = http;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String hostname() {
        return this.hostname;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Nullable
    public NodeIndicesStats indices() {
        return this.indices;
    }

    @Nullable
    public NodeIndicesStats getIndices() {
        return this.indices();
    }

    @Nullable
    public OsStats os() {
        return this.os;
    }

    @Nullable
    public OsStats getOs() {
        return this.os();
    }

    @Nullable
    public ProcessStats process() {
        return this.process;
    }

    @Nullable
    public ProcessStats getProcess() {
        return this.process();
    }

    @Nullable
    public JvmStats jvm() {
        return this.jvm;
    }

    @Nullable
    public JvmStats getJvm() {
        return this.jvm();
    }

    @Nullable
    public ThreadPoolStats threadPool() {
        return this.threadPool;
    }

    @Nullable
    public ThreadPoolStats getThreadPool() {
        return this.threadPool();
    }

    @Nullable
    public NetworkStats network() {
        return this.network;
    }

    @Nullable
    public NetworkStats getNetwork() {
        return this.network();
    }

    @Nullable
    public FsStats fs() {
        return this.fs;
    }

    @Nullable
    public FsStats getFs() {
        return this.fs();
    }

    @Nullable
    public TransportStats transport() {
        return this.transport;
    }

    @Nullable
    public TransportStats getTransport() {
        return this.transport();
    }

    @Nullable
    public HttpStats http() {
        return this.http;
    }

    @Nullable
    public HttpStats getHttp() {
        return this.http();
    }

    public static NodeStats readNodeStats(StreamInput in) throws IOException {
        NodeStats nodeInfo = new NodeStats();
        nodeInfo.readFrom(in);
        return nodeInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.hostname = in.readUTF();
        }
        if (in.readBoolean()) {
            this.indices = NodeIndicesStats.readIndicesStats(in);
        }
        if (in.readBoolean()) {
            this.os = OsStats.readOsStats(in);
        }
        if (in.readBoolean()) {
            this.process = ProcessStats.readProcessStats(in);
        }
        if (in.readBoolean()) {
            this.jvm = JvmStats.readJvmStats(in);
        }
        if (in.readBoolean()) {
            this.threadPool = ThreadPoolStats.readThreadPoolStats(in);
        }
        if (in.readBoolean()) {
            this.network = NetworkStats.readNetworkStats(in);
        }
        if (in.readBoolean()) {
            this.fs = FsStats.readFsStats(in);
        }
        if (in.readBoolean()) {
            this.transport = TransportStats.readTransportStats(in);
        }
        if (in.readBoolean()) {
            this.http = HttpStats.readHttpStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.hostname == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.hostname);
        }
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        if (this.os == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.os.writeTo(out);
        }
        if (this.process == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.process.writeTo(out);
        }
        if (this.jvm == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jvm.writeTo(out);
        }
        if (this.threadPool == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.threadPool.writeTo(out);
        }
        if (this.network == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.network.writeTo(out);
        }
        if (this.fs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.fs.writeTo(out);
        }
        if (this.transport == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.transport.writeTo(out);
        }
        if (this.http == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.http.writeTo(out);
        }
    }
}

