/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.annotations.GwtIncompatible;
import org.elasticsearch.common.collect.ImmutableAsList;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.TransformedImmutableSet;

@GwtCompatible(emulated=true)
abstract class ImmutableMapKeySet<K, V>
extends TransformedImmutableSet<Map.Entry<K, V>, K> {
    ImmutableMapKeySet(ImmutableSet<Map.Entry<K, V>> entrySet) {
        super(entrySet);
    }

    ImmutableMapKeySet(ImmutableSet<Map.Entry<K, V>> entrySet, int hashCode) {
        super(entrySet, hashCode);
    }

    abstract ImmutableMap<K, V> map();

    @Override
    K transform(Map.Entry<K, V> entry) {
        return entry.getKey();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map().containsKey(object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<K> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map().entrySet())).asList();
        return new ImmutableAsList<K>(){

            @Override
            public K get(int index) {
                return ((Map.Entry)entryList.get(index)).getKey();
            }

            @Override
            ImmutableCollection<K> delegateCollection() {
                return ImmutableMapKeySet.this;
            }
        };
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map());
    }

    @GwtIncompatible(value="serialization")
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

