/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.CompressedIndexOutput;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.snappy.SnappyCompressor;
import org.elasticsearch.common.compress.snappy.xerial.XerialSnappyCompressedIndexInput;
import org.elasticsearch.common.compress.snappy.xerial.XerialSnappyCompressedIndexOutput;
import org.elasticsearch.common.compress.snappy.xerial.XerialSnappyCompressedStreamInput;
import org.elasticsearch.common.compress.snappy.xerial.XerialSnappyCompressedStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressor
extends SnappyCompressor {
    @Override
    public String type() {
        return "snappy";
    }

    @Override
    protected int maxCompressedLength(int length) {
        return Snappy.maxCompressedLength((int)length);
    }

    @Override
    public CompressedStreamInput streamInput(StreamInput in) throws IOException {
        return new XerialSnappyCompressedStreamInput(in, this.compressorContext);
    }

    @Override
    public CompressedStreamOutput streamOutput(StreamOutput out) throws IOException {
        return new XerialSnappyCompressedStreamOutput(out, this.compressorContext);
    }

    @Override
    public CompressedIndexInput indexInput(IndexInput in) throws IOException {
        return new XerialSnappyCompressedIndexInput(in, this.compressorContext);
    }

    @Override
    public CompressedIndexOutput indexOutput(IndexOutput out) throws IOException {
        return new XerialSnappyCompressedIndexOutput(out, this.compressorContext);
    }
}

