/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e.extra;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.elasticsearch.common.util.concurrent.jsr166e.SequenceLock;

public class ReadMostlyVector<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    volatile Object[] array;
    final SequenceLock lock;
    volatile int count;
    final int capacityIncrement;

    public ReadMostlyVector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.array = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.lock = new SequenceLock();
    }

    public ReadMostlyVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ReadMostlyVector() {
        this(10, 0);
    }

    public ReadMostlyVector(Collection<? extends E> c) {
        Object[] elements = c.toArray();
        if (elements.getClass() != Object[].class) {
            elements = Arrays.copyOf(elements, elements.length, Object[].class);
        }
        this.array = elements;
        this.count = elements.length;
        this.capacityIncrement = 0;
        this.lock = new SequenceLock();
    }

    ReadMostlyVector(Object[] array, int count, int capacityIncrement) {
        this.array = array;
        this.count = count;
        this.capacityIncrement = capacityIncrement;
        this.lock = new SequenceLock();
    }

    final Object[] grow(int minCapacity) {
        int oldCapacity = this.array.length;
        int newCapacity = oldCapacity + (this.capacityIncrement > 0 ? this.capacityIncrement : oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ReadMostlyVector.hugeCapacity(minCapacity);
        }
        this.array = Arrays.copyOf(this.array, newCapacity);
        return this.array;
    }

    static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    final int validatedIndexOf(Object x, Object[] items, int index, int fence, long seq) {
        for (int i = index; i < fence; ++i) {
            Object e = items[i];
            if (this.lock.getSequence() != seq) break;
            if (!(x == null ? e == null : x.equals(e))) continue;
            return i;
        }
        return -1;
    }

    final int rawIndexOf(Object x, int index, int fence) {
        Object[] items = this.array;
        for (int i = index; i < fence; ++i) {
            Object e = items[i];
            if (!(x == null ? e == null : x.equals(e))) continue;
            return i;
        }
        return -1;
    }

    final int validatedLastIndexOf(Object x, Object[] items, int index, int origin, long seq) {
        for (int i = index; i >= origin; --i) {
            Object e = items[i];
            if (this.lock.getSequence() != seq) break;
            if (!(x == null ? e == null : x.equals(e))) continue;
            return i;
        }
        return -1;
    }

    final int rawLastIndexOf(Object x, int index, int origin) {
        Object[] items = this.array;
        for (int i = index; i >= origin; --i) {
            Object e = items[i];
            if (!(x == null ? e == null : x.equals(e))) continue;
            return i;
        }
        return -1;
    }

    final void rawAdd(E e) {
        int n = this.count;
        Object[] items = this.array;
        if (n >= items.length) {
            items = this.grow(n + 1);
        }
        items[n] = e;
        this.count = n + 1;
    }

    final void rawAddAt(int index, E e) {
        int n = this.count;
        Object[] items = this.array;
        if (index > n) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (n >= items.length) {
            items = this.grow(n + 1);
        }
        if (index < n) {
            System.arraycopy(items, index, items, index + 1, n - index);
        }
        items[index] = e;
        this.count = n + 1;
    }

    final boolean rawAddAllAt(int index, Object[] elements) {
        int mv;
        int n = this.count;
        Object[] items = this.array;
        if (index < 0 || index > n) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int len = elements.length;
        if (len == 0) {
            return false;
        }
        int newCount = n + len;
        if (newCount >= items.length) {
            items = this.grow(newCount);
        }
        if ((mv = n - index) > 0) {
            System.arraycopy(items, index, items, index + len, mv);
        }
        System.arraycopy(elements, 0, items, index, len);
        this.count = newCount;
        return true;
    }

    final boolean rawRemoveAt(int index) {
        int n = this.count - 1;
        Object[] items = this.array;
        if (index < 0 || index > n) {
            return false;
        }
        int mv = n - index;
        if (mv > 0) {
            System.arraycopy(items, index + 1, items, index, mv);
        }
        items[n] = null;
        this.count = n;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean internalRemoveAll(Collection<?> c, int origin, int bound) {
        SequenceLock lock = this.lock;
        boolean removed = false;
        lock.lock();
        try {
            int fence;
            int n = this.count;
            int n2 = fence = bound < 0 || bound > n ? n : bound;
            if (origin >= 0 && origin < fence) {
                for (Object x : c) {
                    while (this.rawRemoveAt(this.rawIndexOf(x, origin, fence))) {
                        removed = true;
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean internalRetainAll(Collection<?> c, int origin, int bound) {
        SequenceLock lock = this.lock;
        boolean removed = false;
        if (c != this) {
            lock.lock();
            try {
                int fence;
                Object[] items = this.array;
                int i = origin;
                int n = this.count;
                int n2 = fence = bound < 0 || bound > n ? n : bound;
                while (i >= 0 && i < fence) {
                    int mv;
                    if (c.contains(items[i])) {
                        ++i;
                        continue;
                    }
                    --fence;
                    if ((mv = --n - i) <= 0) continue;
                    System.arraycopy(items, i + 1, items, i, mv);
                }
                if (this.count != n) {
                    this.count = n;
                    removed = true;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return removed;
    }

    final void internalClear(int origin, int bound) {
        int fence;
        int n = this.count;
        int n2 = fence = bound < 0 || bound > n ? n : bound;
        if (origin >= 0 && origin < fence) {
            Object[] items = this.array;
            int removed = fence - origin;
            int newCount = n - removed;
            int mv = n - (origin + removed);
            if (mv > 0) {
                System.arraycopy(items, origin + removed, items, origin, mv);
            }
            for (int i = n; i < newCount; ++i) {
                items[i] = null;
            }
            this.count = newCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean internalContainsAll(Collection<?> c, int origin, int bound) {
        boolean contained;
        SequenceLock lock = this.lock;
        boolean locked = false;
        try {
            while (true) {
                int fence;
                long seq = lock.awaitAvailability();
                int n = this.count;
                Object[] items = this.array;
                int len = items.length;
                if (n > len) continue;
                int n2 = fence = bound < 0 || bound > n ? n : bound;
                if (origin < 0) {
                    contained = false;
                } else {
                    contained = true;
                    for (Object e : c) {
                        int idx = locked ? this.rawIndexOf(e, origin, fence) : this.validatedIndexOf(e, items, origin, fence, seq);
                        if (idx >= 0) continue;
                        contained = false;
                        break;
                    }
                }
                if (lock.getSequence() == seq) {
                    break;
                }
                lock.lock();
                locked = true;
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return contained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean internalEquals(List<?> list, int origin, int bound) {
        boolean equal;
        SequenceLock lock = this.lock;
        boolean locked = false;
        try {
            while (true) {
                long seq = lock.awaitAvailability();
                int n = this.count;
                Object[] items = this.array;
                if (n > items.length || origin < 0) {
                    equal = false;
                } else {
                    equal = true;
                    int fence = bound < 0 || bound > n ? n : bound;
                    Iterator<?> it = list.iterator();
                    for (int i = origin; i < fence; ++i) {
                        Object y;
                        Object x = items[i];
                        if (!(!locked && lock.getSequence() != seq || !it.hasNext() || (y = it.next()) == null ? x != null : !y.equals(x))) continue;
                        equal = false;
                        break;
                    }
                    if (equal && it.hasNext()) {
                        equal = false;
                    }
                }
                if (lock.getSequence() == seq) {
                    break;
                }
                lock.lock();
                locked = true;
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int internalHashCode(int origin, int bound) {
        int hash;
        SequenceLock lock = this.lock;
        boolean locked = false;
        try {
            while (true) {
                int fence;
                hash = 1;
                long seq = lock.awaitAvailability();
                int n = this.count;
                Object[] items = this.array;
                int len = items.length;
                if (n > len) continue;
                int n2 = fence = bound < 0 || bound > n ? n : bound;
                if (origin >= 0) {
                    for (int i = origin; i < fence; ++i) {
                        Object e = items[i];
                        hash = 31 * hash + (e == null ? 0 : e.hashCode());
                    }
                }
                if (lock.getSequence() == seq) {
                    break;
                }
                lock.lock();
                locked = true;
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String internalToString(int origin, int bound) {
        String ret;
        SequenceLock lock = this.lock;
        boolean locked = false;
        try {
            block3: while (true) {
                int fence;
                long seq = lock.awaitAvailability();
                int n = this.count;
                Object[] items = this.array;
                int len = items.length;
                if (n > len) continue;
                int n2 = fence = bound < 0 || bound > n ? n : bound;
                if (origin < 0 || origin == fence) {
                    ret = "[]";
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    int i = origin;
                    while (true) {
                        Object e;
                        if ((e = items[i]) == this) {
                            sb.append("(this Collection)");
                        } else {
                            if (!locked && lock.getSequence() != seq) continue block3;
                            sb.append(e.toString());
                        }
                        if (++i >= fence) break;
                        sb.append(',').append(' ');
                    }
                    ret = sb.append(']').toString();
                }
                if (lock.getSequence() == seq) {
                    break;
                }
                lock.lock();
                locked = true;
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] internalToArray(int origin, int bound) {
        Object[] result;
        SequenceLock lock = this.lock;
        boolean locked = false;
        try {
            while (true) {
                int fence;
                result = null;
                long seq = lock.awaitAvailability();
                int n = this.count;
                Object[] items = this.array;
                int len = items.length;
                if (n > len) continue;
                int n2 = fence = bound < 0 || bound > n ? n : bound;
                if (origin >= 0) {
                    result = Arrays.copyOfRange(items, origin, fence, Object[].class);
                }
                if (lock.getSequence() == seq) {
                    break;
                }
                lock.lock();
                locked = true;
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T[] internalToArray(T[] a, int origin, int bound) {
        T[] result;
        int alen = a.length;
        SequenceLock lock = this.lock;
        boolean locked = false;
        try {
            while (true) {
                long seq = lock.awaitAvailability();
                int n = this.count;
                Object[] items = this.array;
                int len = items.length;
                if (n > len) continue;
                int fence = bound < 0 || bound > n ? n : bound;
                int rlen = fence - origin;
                if (rlen < 0) {
                    rlen = 0;
                }
                if (origin < 0 || alen >= rlen) {
                    if (rlen > 0) {
                        System.arraycopy(items, 0, a, origin, rlen);
                    }
                    if (alen > rlen) {
                        a[rlen] = null;
                    }
                    result = a;
                } else {
                    result = Arrays.copyOfRange(items, origin, fence, a.getClass());
                }
                if (lock.getSequence() == seq) {
                    break;
                }
                lock.lock();
                locked = true;
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            this.rawAdd(e);
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            this.rawAddAt(index, element);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] elements = c.toArray();
        int len = elements.length;
        if (len == 0) {
            return false;
        }
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            Object[] items = this.array;
            int n = this.count;
            int newCount = n + len;
            if (newCount >= items.length) {
                items = this.grow(newCount);
            }
            System.arraycopy(elements, 0, items, n, len);
            this.count = newCount;
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean ret;
        SequenceLock lock = this.lock;
        Object[] elements = c.toArray();
        lock.lock();
        try {
            ret = this.rawAddAllAt(index, elements);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            Object[] items = this.array;
            for (int i = 0; i < n; ++i) {
                items[i] = null;
            }
            this.count = 0;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o, 0) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.internalContainsAll(c, 0, -1);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        return this.internalEquals((List)o, 0, -1);
    }

    @Override
    public E get(int index) {
        Object e;
        int n;
        long seq;
        SequenceLock lock = this.lock;
        do {
            seq = lock.awaitAvailability();
            n = this.count;
            Object[] items = this.array;
            Object object = e = index < items.length ? items[index] : null;
        } while (lock.getSequence() != seq);
        if (index >= n) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (E)e;
    }

    @Override
    public int hashCode() {
        return this.internalHashCode(0, -1);
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        long seq;
        Object[] items;
        int n;
        SequenceLock lock = this.lock;
        do {
            seq = lock.awaitAvailability();
        } while ((n = this.count) > (items = this.array).length);
        for (int i = n - 1; i >= 0; --i) {
            Object e = items[i];
            if (lock.getSequence() != seq) {
                lock.lock();
                try {
                    int n2 = this.rawLastIndexOf(o, this.count - 1, 0);
                    return n2;
                }
                finally {
                    lock.unlock();
                }
            }
            if (!(o == null ? e == null : o.equals(e))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Itr(this, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new Itr(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            if (index < 0 || index >= this.count) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            Object oldValue = this.array[index];
            this.rawRemoveAt(index);
            Object object = oldValue;
            return (E)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.rawRemoveAt(this.rawIndexOf(o, 0, this.count));
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.internalRemoveAll(c, 0, -1);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.internalRetainAll(c, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            Object[] items = this.array;
            if (index < 0 || index >= this.count) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            Object oldValue = items[index];
            items[index] = element;
            Object object = oldValue;
            return (E)object;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int c = this.size();
        int ssize = toIndex - fromIndex;
        if (fromIndex < 0 || toIndex > c || ssize < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new ReadMostlyVectorSublist(this, fromIndex, ssize);
    }

    @Override
    public Object[] toArray() {
        return this.internalToArray(0, -1);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.internalToArray(a, 0, -1);
    }

    public String toString() {
        return this.internalToString(0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(E e) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            if (this.rawIndexOf(e, 0, this.count) < 0) {
                this.rawAdd(e);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        int added = 0;
        Object[] cs = c.toArray();
        int clen = cs.length;
        if (clen != 0) {
            this.lock.lock();
            try {
                for (int i = 0; i < clen; ++i) {
                    Object e = cs[i];
                    if (this.rawIndexOf(e, 0, this.count) >= 0) continue;
                    this.rawAdd(e);
                    ++added;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return added;
    }

    public Iterator<E> snapshotIterator() {
        return new SnapshotIterator(this);
    }

    public E firstElement() {
        Object e;
        int n;
        long seq;
        SequenceLock lock = this.lock;
        do {
            seq = lock.awaitAvailability();
            Object[] items = this.array;
            n = this.count;
            Object object = e = items.length > 0 ? items[0] : null;
        } while (lock.getSequence() != seq);
        if (n <= 0) {
            throw new NoSuchElementException();
        }
        return (E)e;
    }

    public E lastElement() {
        Object e;
        int n;
        long seq;
        SequenceLock lock = this.lock;
        do {
            seq = lock.awaitAvailability();
            Object[] items = this.array;
            n = this.count;
            Object object = e = n > 0 && items.length >= n ? items[n - 1] : null;
        } while (lock.getSequence() != seq);
        if (n <= 0) {
            throw new NoSuchElementException();
        }
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o, int index) {
        SequenceLock lock = this.lock;
        long seq = lock.awaitAvailability();
        Object[] items = this.array;
        int n = this.count;
        int idx = -1;
        if (n <= items.length) {
            idx = this.validatedIndexOf(o, items, index, n, seq);
        }
        if (lock.getSequence() != seq) {
            lock.lock();
            try {
                idx = this.rawIndexOf(o, index, this.count);
            }
            finally {
                lock.unlock();
            }
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o, int index) {
        SequenceLock lock = this.lock;
        long seq = lock.awaitAvailability();
        Object[] items = this.array;
        int n = this.count;
        int idx = -1;
        if (index < Math.min(n, items.length)) {
            idx = this.validatedLastIndexOf(o, items, index, 0, seq);
        }
        if (lock.getSequence() != seq) {
            lock.lock();
            try {
                n = this.count;
                if (index < n) {
                    idx = this.rawLastIndexOf(o, index, 0);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (index >= n) {
            throw new IndexOutOfBoundsException(index + " >= " + n);
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new ArrayIndexOutOfBoundsException(newSize);
        }
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            if (newSize > n) {
                this.grow(newSize);
            } else {
                Object[] items = this.array;
                for (int i = newSize; i < n; ++i) {
                    items[i] = null;
                }
            }
            this.count = newSize;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(Object[] anArray) {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            System.arraycopy(this.array, 0, anArray, 0, this.count);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            Object[] items = this.array;
            int n = this.count;
            if (n < items.length) {
                this.array = Arrays.copyOf(items, n);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            SequenceLock lock = this.lock;
            lock.lock();
            try {
                if (minCapacity - this.array.length > 0) {
                    this.grow(minCapacity);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public Enumeration<E> elements() {
        return new Itr(this, 0);
    }

    public int capacity() {
        return this.array.length;
    }

    public E elementAt(int index) {
        return this.get(index);
    }

    public void setElementAt(E obj, int index) {
        this.set(index, obj);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public void insertElementAt(E obj, int index) {
        this.add(index, obj);
    }

    public void addElement(E obj) {
        this.add(obj);
    }

    public boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public void removeAllElements() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMostlyVector<E> clone() {
        SequenceLock lock = this.lock;
        Object[] a = null;
        boolean retry = false;
        long seq = lock.awaitAvailability();
        int n = this.count;
        Object[] items = this.array;
        if (n <= items.length) {
            a = Arrays.copyOf(items, n);
        } else {
            retry = true;
        }
        if (retry || lock.getSequence() != seq) {
            lock.lock();
            try {
                n = this.count;
                a = Arrays.copyOf(this.array, n);
            }
            finally {
                lock.unlock();
            }
        }
        return new ReadMostlyVector<E>(a, n, this.capacityIncrement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        SequenceLock lock = this.lock;
        lock.lock();
        try {
            s.defaultWriteObject();
        }
        finally {
            lock.unlock();
        }
    }

    static final class SubItr<E>
    implements ListIterator<E> {
        final ReadMostlyVectorSublist<E> sublist;
        final ReadMostlyVector<E> list;
        final SequenceLock lock;
        Object[] items;
        E next;
        E prev;
        long seq;
        int cursor;
        int fence;
        int lastRet;
        boolean validNext;
        boolean validPrev;

        SubItr(ReadMostlyVectorSublist<E> sublist, int index) {
            this.sublist = sublist;
            this.list = sublist.list;
            this.lock = this.list.lock;
            this.cursor = index;
            this.lastRet = -1;
            this.refresh();
            if (index < 0 || index > this.fence) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }

        private void refresh() {
            this.validPrev = false;
            this.validNext = false;
            do {
                this.seq = this.lock.awaitAvailability();
                this.items = this.list.array;
                int n = this.list.count;
                if (n > this.items.length) continue;
                int b = this.sublist.offset + this.sublist.size;
                int n2 = this.fence = b < n ? b : n;
            } while (this.lock.getSequence() != this.seq);
        }

        @Override
        public boolean hasNext() {
            boolean valid;
            int i = this.cursor;
            while (true) {
                if (i >= this.fence || i < 0 || i >= this.items.length) {
                    valid = false;
                    break;
                }
                this.next = this.items[i];
                if (this.lock.getSequence() == this.seq) {
                    valid = true;
                    break;
                }
                this.refresh();
            }
            this.validNext = valid;
            return this.validNext;
        }

        @Override
        public boolean hasPrevious() {
            boolean valid;
            int i = this.cursor - 1;
            while (true) {
                if (i >= this.fence || i < 0 || i >= this.items.length) {
                    valid = false;
                    break;
                }
                this.prev = this.items[i];
                if (this.lock.getSequence() == this.seq) {
                    valid = true;
                    break;
                }
                this.refresh();
            }
            this.validPrev = valid;
            return this.validPrev;
        }

        @Override
        public E next() {
            if (this.validNext || this.hasNext()) {
                this.validNext = false;
                this.lastRet = this.cursor++;
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public E previous() {
            if (this.validPrev || this.hasPrevious()) {
                this.validPrev = false;
                this.lastRet = this.cursor--;
                return this.prev;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.cursor - this.sublist.offset;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1 - this.sublist.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int i = this.lastRet;
            if (i < 0) {
                throw new IllegalStateException();
            }
            this.cursor = i;
            this.lastRet = -1;
            this.lock.lock();
            try {
                if (i < this.list.count) {
                    this.list.remove(i);
                    --this.sublist.size;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            int i = this.lastRet;
            if (i < 0) {
                throw new IllegalStateException();
            }
            this.lock.lock();
            try {
                if (i < this.list.count) {
                    this.list.set(i, e);
                }
            }
            finally {
                this.lock.unlock();
            }
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i = this.cursor;
            if (i < 0) {
                throw new IllegalStateException();
            }
            this.cursor = i + 1;
            this.lastRet = -1;
            this.lock.lock();
            try {
                if (i <= this.list.count) {
                    this.list.add(i, e);
                    ++this.sublist.size;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.refresh();
        }
    }

    static final class ReadMostlyVectorSublist<E>
    implements List<E>,
    RandomAccess,
    Serializable {
        static final long serialVersionUID = 3041673470172026059L;
        final ReadMostlyVector<E> list;
        final int offset;
        volatile int size;

        ReadMostlyVectorSublist(ReadMostlyVector<E> list, int offset, int size) {
            this.list = list;
            this.offset = offset;
            this.size = size;
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E element) {
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                int c = this.size;
                this.list.rawAddAt(c + this.offset, element);
                this.size = c + 1;
            }
            finally {
                lock.unlock();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                if (index < 0 || index > this.size) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                this.list.rawAddAt(index + this.offset, element);
                ++this.size;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object[] elements = c.toArray();
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                int s = this.size;
                int pc = this.list.count;
                this.list.rawAddAllAt(this.offset + s, elements);
                int added = this.list.count - pc;
                this.size = s + added;
                boolean bl = added != 0;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object[] elements = c.toArray();
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                int s = this.size;
                if (index < 0 || index > s) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                int pc = this.list.count;
                this.list.rawAddAllAt(index + this.offset, elements);
                int added = this.list.count - pc;
                this.size = s + added;
                boolean bl = added != 0;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                this.list.internalClear(this.offset, this.offset + this.size);
                this.size = 0;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.internalContainsAll(c, this.offset, this.offset + this.size);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            return this.list.internalEquals((List)o, this.offset, this.offset + this.size);
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return this.list.get(index + this.offset);
        }

        @Override
        public int hashCode() {
            return this.list.internalHashCode(this.offset, this.offset + this.size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            int idx;
            SequenceLock lock = this.list.lock;
            long seq = lock.awaitAvailability();
            int c = this.list.count;
            Object[] items = this.list.array;
            if (c <= items.length) {
                idx = this.list.validatedIndexOf(o, items, this.offset, this.offset + this.size, seq);
                if (lock.getSequence() == seq) {
                    return idx < 0 ? -1 : idx - this.offset;
                }
            }
            lock.lock();
            try {
                idx = this.list.rawIndexOf(o, this.offset, this.offset + this.size);
                int n = idx < 0 ? -1 : idx - this.offset;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new SubItr(this, this.offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            int idx;
            SequenceLock lock = this.list.lock;
            long seq = lock.awaitAvailability();
            int c = this.list.count;
            Object[] items = this.list.array;
            if (c <= items.length) {
                idx = this.list.validatedLastIndexOf(o, items, this.offset + this.size - 1, this.offset, seq);
                if (lock.getSequence() == seq) {
                    return idx < 0 ? -1 : idx - this.offset;
                }
            }
            lock.lock();
            try {
                idx = this.list.rawLastIndexOf(o, this.offset + this.size - 1, this.offset);
                int n = idx < 0 ? -1 : idx - this.offset;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return new SubItr(this, this.offset);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new SubItr(this, index + this.offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                Object[] items = this.list.array;
                int i = index + this.offset;
                if (index < 0 || index >= this.size || i >= items.length) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                Object result = items[i];
                this.list.rawRemoveAt(i);
                --this.size;
                Object object = result;
                return (E)object;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            SequenceLock lock = this.list.lock;
            lock.lock();
            try {
                if (this.list.rawRemoveAt(this.list.rawIndexOf(o, this.offset, this.offset + this.size))) {
                    --this.size;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.internalRemoveAll(c, this.offset, this.offset + this.size);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.internalRetainAll(c, this.offset, this.offset + this.size);
        }

        @Override
        public E set(int index, E element) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return this.list.set(index + this.offset, element);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            int c = this.size;
            int ssize = toIndex - fromIndex;
            if (fromIndex < 0 || toIndex > c || ssize < 0) {
                throw new IndexOutOfBoundsException();
            }
            return new ReadMostlyVectorSublist<E>(this.list, this.offset + fromIndex, ssize);
        }

        @Override
        public Object[] toArray() {
            return this.list.internalToArray(this.offset, this.offset + this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.internalToArray(a, this.offset, this.offset + this.size);
        }

        public String toString() {
            return this.list.internalToString(this.offset, this.offset + this.size);
        }
    }

    static final class Itr<E>
    implements ListIterator<E>,
    Enumeration<E> {
        final ReadMostlyVector<E> list;
        final SequenceLock lock;
        Object[] items;
        E next;
        E prev;
        long seq;
        int cursor;
        int fence;
        int lastRet;
        boolean validNext;
        boolean validPrev;

        Itr(ReadMostlyVector<E> list, int index) {
            this.list = list;
            this.lock = list.lock;
            this.cursor = index;
            this.lastRet = -1;
            this.refresh();
            if (index < 0 || index > this.fence) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }

        private void refresh() {
            this.validPrev = false;
            this.validNext = false;
            do {
                this.seq = this.lock.awaitAvailability();
                this.items = this.list.array;
            } while ((this.fence = this.list.count) > this.items.length || this.lock.getSequence() != this.seq);
        }

        @Override
        public boolean hasNext() {
            boolean valid;
            int i = this.cursor;
            while (true) {
                if (i >= this.fence || i < 0 || i >= this.items.length) {
                    valid = false;
                    break;
                }
                this.next = this.items[i];
                if (this.lock.getSequence() == this.seq) {
                    valid = true;
                    break;
                }
                this.refresh();
            }
            this.validNext = valid;
            return this.validNext;
        }

        @Override
        public boolean hasPrevious() {
            boolean valid;
            int i = this.cursor - 1;
            while (true) {
                if (i >= this.fence || i < 0 || i >= this.items.length) {
                    valid = false;
                    break;
                }
                this.prev = this.items[i];
                if (this.lock.getSequence() == this.seq) {
                    valid = true;
                    break;
                }
                this.refresh();
            }
            this.validPrev = valid;
            return this.validPrev;
        }

        @Override
        public E next() {
            if (this.validNext || this.hasNext()) {
                this.validNext = false;
                this.lastRet = this.cursor++;
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public E previous() {
            if (this.validPrev || this.hasPrevious()) {
                this.validPrev = false;
                this.lastRet = this.cursor--;
                return this.prev;
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int i = this.lastRet;
            if (i < 0) {
                throw new IllegalStateException();
            }
            this.lock.lock();
            try {
                if (i < this.list.count) {
                    this.list.remove(i);
                }
            }
            finally {
                this.lock.unlock();
            }
            this.cursor = i;
            this.lastRet = -1;
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            int i = this.lastRet;
            if (i < 0) {
                throw new IllegalStateException();
            }
            this.lock.lock();
            try {
                if (i < this.list.count) {
                    this.list.set(i, e);
                }
            }
            finally {
                this.lock.unlock();
            }
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i = this.cursor;
            if (i < 0) {
                throw new IllegalStateException();
            }
            this.lock.lock();
            try {
                if (i <= this.list.count) {
                    this.list.add(i, e);
                }
            }
            finally {
                this.lock.unlock();
            }
            this.cursor = i + 1;
            this.lastRet = -1;
            this.refresh();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public E nextElement() {
            return this.next();
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }
    }

    static final class SnapshotIterator<E>
    implements Iterator<E> {
        private final Object[] items;
        private int cursor;

        SnapshotIterator(ReadMostlyVector<E> v) {
            this.items = v.toArray();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.items.length;
        }

        @Override
        public E next() {
            if (this.cursor < this.items.length) {
                return (E)this.items[this.cursor++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

