/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.geo.GeoJSONShapeParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoShapeFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.shape.ShapeFetchService;

public class GeoShapeFilterParser
implements FilterParser {
    public static final String NAME = "geo_shape";
    private ShapeFetchService fetchService;

    @Override
    public String[] names() {
        return new String[]{NAME, "geoShape"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        ShapeRelation shapeRelation = null;
        Shape shape = null;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String id = null;
        String type = null;
        String index = "shapes";
        String shapeFieldName = "shape";
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if ("shape".equals(currentFieldName)) {
                        shape = GeoJSONShapeParser.parse(parser);
                        continue;
                    }
                    if ("relation".equals(currentFieldName)) {
                        shapeRelation = ShapeRelation.getRelationByName(parser.text());
                        if (shapeRelation != null) continue;
                        throw new QueryParsingException(parseContext.index(), "Unknown shape operation [" + parser.text() + " ]");
                    }
                    if (!"indexed_shape".equals(currentFieldName) && !"indexedShape".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("id".equals(currentFieldName)) {
                            id = parser.text();
                            continue;
                        }
                        if ("type".equals(currentFieldName)) {
                            type = parser.text();
                            continue;
                        }
                        if ("index".equals(currentFieldName)) {
                            index = parser.text();
                            continue;
                        }
                        if (!"shape_field_name".equals(currentFieldName)) continue;
                        shapeFieldName = parser.text();
                    }
                    if (id == null) {
                        throw new QueryParsingException(parseContext.index(), "ID for indexed shape not provided");
                    }
                    if (type == null) {
                        throw new QueryParsingException(parseContext.index(), "Type for indexed shape not provided");
                    }
                    shape = this.fetchService.fetch(id, type, index, shapeFieldName);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if (!"_cache_key".equals(currentFieldName)) continue;
            cacheKey = new CacheKeyFilter.Key(parser.text());
        }
        if (shape == null) {
            throw new QueryParsingException(parseContext.index(), "No Shape defined");
        }
        if (shapeRelation == null) {
            throw new QueryParsingException(parseContext.index(), "No Shape Relation defined");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers == null || !smartNameFieldMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "Failed to find geo_shape field [" + fieldName + "]");
        }
        FieldMapper fieldMapper = smartNameFieldMappers.mapper();
        if (!(fieldMapper instanceof GeoShapeFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "Field [" + fieldName + "] is not a geo_shape");
        }
        GeoShapeFieldMapper shapeFieldMapper = (GeoShapeFieldMapper)fieldMapper;
        Filter filter = shapeFieldMapper.spatialStrategy().createFilter(shape, shapeRelation);
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }

    @Inject(optional=true)
    public void setFetchService(@Nullable ShapeFetchService fetchService) {
        this.fetchService = fetchService;
    }

    public static class DEFAULTS {
        public static final String INDEX_NAME = "shapes";
        public static final String SHAPE_FIELD_NAME = "shape";
    }
}

