/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HasChildQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<HasChildQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private String childType;
    private String scope;
    private float boost = 1.0f;
    private String scoreType;
    private String executionType;

    public HasChildQueryBuilder(String type, QueryBuilder queryBuilder) {
        this.childType = type;
        this.queryBuilder = queryBuilder;
    }

    public HasChildQueryBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public HasChildQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public HasChildQueryBuilder scoreType(String scoreType) {
        this.scoreType = scoreType;
        return this;
    }

    public HasChildQueryBuilder executionType(String executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("has_child");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("child_type", this.childType);
        if (this.scope != null) {
            builder.field("_scope", this.scope);
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.scoreType != null) {
            builder.field("score_type", this.scoreType);
        }
        builder.endObject();
    }
}

